/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.item.selector.web.internal;

import com.liferay.item.selector.BaseItemSelectorCriterionHandler;
import com.liferay.item.selector.ItemSelectorCriterionHandler;
import com.liferay.object.item.selector.ObjectDefinitionItemSelectorCriterion;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Jonathan McCann
 */
@Component(service = ItemSelectorCriterionHandler.class)
public class ObjectDefinitionItemSelectorCriterionHandler
	extends BaseItemSelectorCriterionHandler
		<ObjectDefinitionItemSelectorCriterion> {

	@Override
	public Class<ObjectDefinitionItemSelectorCriterion>
		getItemSelectorCriterionClass() {

		return ObjectDefinitionItemSelectorCriterion.class;
	}

	@Activate
	@Override
	protected void activate(BundleContext bundleContext) {
		super.activate(bundleContext);
	}

	@Deactivate
	@Override
	protected void deactivate() {
		super.deactivate();
	}

}