/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.http;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;

public class OAuthClientEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OAuthClientEntryServiceHttp.class);
    private static final Class<?>[] _addOAuthClientEntryParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE, String.class, String.class};
    private static final Class<?>[] _deleteOAuthClientEntryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteOAuthClientEntryParameterTypes2 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _getAuthServerWellKnownURISuffixOAuthClientEntriesParameterTypes3 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getCompanyOAuthClientEntriesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyOAuthClientEntriesParameterTypes5 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getOAuthClientEntryParameterTypes6 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _getUserOAuthClientEntriesParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserOAuthClientEntriesParameterTypes8 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _updateOAuthClientEntryParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE, String.class, String.class};

    public static OAuthClientEntry addOAuthClientEntry(HttpPrincipal httpPrincipal, long userId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, long metadataCacheTime, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "addOAuthClientEntry", (Class[])_addOAuthClientEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, authRequestParametersJSON, authServerWellKnownURI, infoJSON, metadataCacheTime, oidcUserInfoMapperJSON, tokenRequestParametersJSON});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthClientEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthClientEntry deleteOAuthClientEntry(HttpPrincipal httpPrincipal, long oAuthClientEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "deleteOAuthClientEntry", (Class[])_deleteOAuthClientEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthClientEntryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthClientEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthClientEntry deleteOAuthClientEntry(HttpPrincipal httpPrincipal, long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "deleteOAuthClientEntry", (Class[])_deleteOAuthClientEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, authServerWellKnownURI, clientId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthClientEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuthClientEntry> getAuthServerWellKnownURISuffixOAuthClientEntries(HttpPrincipal httpPrincipal, long companyId, String authServerWellKnownURISuffix) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getAuthServerWellKnownURISuffixOAuthClientEntries", (Class[])_getAuthServerWellKnownURISuffixOAuthClientEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, authServerWellKnownURISuffix});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuthClientEntry> getCompanyOAuthClientEntries(HttpPrincipal httpPrincipal, long companyId) {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getCompanyOAuthClientEntries", (Class[])_getCompanyOAuthClientEntriesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuthClientEntry> getCompanyOAuthClientEntries(HttpPrincipal httpPrincipal, long companyId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getCompanyOAuthClientEntries", (Class[])_getCompanyOAuthClientEntriesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthClientEntry getOAuthClientEntry(HttpPrincipal httpPrincipal, long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getOAuthClientEntry", (Class[])_getOAuthClientEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, authServerWellKnownURI, clientId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthClientEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuthClientEntry> getUserOAuthClientEntries(HttpPrincipal httpPrincipal, long userId) {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getUserOAuthClientEntries", (Class[])_getUserOAuthClientEntriesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuthClientEntry> getUserOAuthClientEntries(HttpPrincipal httpPrincipal, long userId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "getUserOAuthClientEntries", (Class[])_getUserOAuthClientEntriesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthClientEntry updateOAuthClientEntry(HttpPrincipal httpPrincipal, long oAuthClientEntryId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, long metadataCacheTime, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthClientEntryServiceUtil.class, "updateOAuthClientEntry", (Class[])_updateOAuthClientEntryParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthClientEntryId, authRequestParametersJSON, authServerWellKnownURI, infoJSON, metadataCacheTime, oidcUserInfoMapperJSON, tokenRequestParametersJSON});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthClientEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

