/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.multi.factor.authentication.fido2.credential.internal.upgrade.v2_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class MFAFIDO2CredentialUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.dropIndexes("MFAFIDO2CredentialEntry", "credentialKey");
        this.alterColumnType("MFAFIDO2CredentialEntry", "credentialKey", "TEXT null");
        if (!this.hasColumn("MFAFIDO2CredentialEntry", "credentialKeyHash")) {
            this.alterTableAddColumn("MFAFIDO2CredentialEntry", "credentialKeyHash", "LONG");
            this._updateCredentialKeys();
        }
    }

    private void _updateCredentialKey(String credentialKey, int credentialKeyHash) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update MFAFIDO2CredentialEntry set credentialKeyHash = ? where credentialKey = ?");){
            preparedStatement.setLong(1, credentialKeyHash);
            preparedStatement.setString(2, credentialKey);
            preparedStatement.execute();
        }
    }

    private void _updateCredentialKeys() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select MFAFIDO2CredentialEntry.credentialKey from MFAFIDO2CredentialEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String credentialKey = resultSet.getString("credentialKey");
                if (Validator.isNull((String)credentialKey)) continue;
                this._updateCredentialKey(credentialKey, credentialKey.hashCode());
            }
        }
    }
}

