/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.persistence.impl;

import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.model.impl.MDRRuleGroupImpl;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupFinder;
import com.liferay.mobile.device.rules.service.persistence.impl.MDRRuleGroupFinderBaseImpl;
import com.liferay.mobile.device.rules.util.comparator.RuleGroupCreateDateComparator;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MDRRuleGroupFinder.class})
public class MDRRuleGroupFinderImpl
extends MDRRuleGroupFinderBaseImpl
implements MDRRuleGroupFinder {
    public static final String COUNT_BY_G_N = MDRRuleGroupFinder.class.getName() + ".countByG_N";
    public static final String FIND_BY_G_N = MDRRuleGroupFinder.class.getName() + ".findByG_N";
    @Reference
    private CustomSQL _customSQL;
    private final LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap();
    @Reference
    private GroupLocalService _groupLocalService;

    public int countByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params) {
        String[] names = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.countByG_N(groupId, names, params, andOperator);
    }

    public int countByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = this._customSQL.keywords(name);
        return this.countByG_N(groupId, names, params, andOperator);
    }

    public int countByG_N(long groupId, String[] names, LinkedHashMap<String, Object> params, boolean andOperator) {
        names = this._customSQL.keywords(names);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_N);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(params));
            sql = this._customSQL.replaceKeywords(sql, "LOWER(name)", "LIKE", true, names);
            sql = this._customSQL.replaceAndOperator(sql, true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setGroupIds(qPos, groupId, params);
            qPos.add(names, 2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MDRRuleGroup> findByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.findByKeywords(groupId, keywords, params, start, end, (OrderByComparator<MDRRuleGroup>)new RuleGroupCreateDateComparator());
    }

    public List<MDRRuleGroup> findByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<MDRRuleGroup> obc) {
        String[] names = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.findByG_N(groupId, names, params, andOperator, start, end, obc);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.findByG_N(groupId, name, params, andOperator, -1, -1);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        String[] names = this._customSQL.keywords(name);
        return this.findByG_N(groupId, names, params, andOperator, start, end);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String[] names, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.findByG_N(groupId, names, params, andOperator, start, end, (OrderByComparator<MDRRuleGroup>)new RuleGroupCreateDateComparator());
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String[] names, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<MDRRuleGroup> obc) {
        names = this._customSQL.keywords(names);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_N);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(params));
            sql = this._customSQL.replaceKeywords(sql, "LOWER(name)", "LIKE", true, names);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            sql = this._customSQL.replaceOrderBy(sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("MDRRuleGroup", MDRRuleGroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setGroupIds(qPos, groupId, params);
            qPos.add(names, 2);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getGroupIds(Map<String, Object> params) {
        Boolean includeGlobalScope = (Boolean)params.get("includeGlobalScope");
        if (includeGlobalScope != null && includeGlobalScope.booleanValue()) {
            return "((groupId = ?) OR (groupId = ?))";
        }
        return "(groupId = ?)";
    }

    protected void setGroupIds(QueryPos qPos, long groupId, Map<String, Object> params) throws PortalException {
        Boolean includeGlobalScope = (Boolean)params.get("includeGlobalScope");
        if (includeGlobalScope != null && includeGlobalScope.booleanValue()) {
            qPos.add(groupId);
            Group group = this._groupLocalService.getGroup(groupId);
            Group companyGroup = this._groupLocalService.getCompanyGroup(group.getCompanyId());
            qPos.add(companyGroup.getGroupId());
        } else {
            qPos.add(groupId);
        }
    }
}

