/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.base.MDRRuleServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mdr", "json.web.service.context.path=MDRRule"}, service={AopService.class})
public class MDRRuleServiceImpl
extends MDRRuleServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.mobile.device.rules.model.MDRRuleGroup)")
    private ModelResourcePermission<MDRRuleGroup> _mdrRuleGroupModelResourcePermission;

    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), ruleGroupId, "UPDATE");
        return this.mdrRuleLocalService.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettings, ServiceContext serviceContext) throws PortalException {
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), ruleGroupId, "UPDATE");
        return this.mdrRuleLocalService.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public void deleteRule(long ruleId) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), rule.getRuleGroupId(), "UPDATE");
        this.mdrRuleLocalService.deleteRule(rule);
    }

    public MDRRule fetchRule(long ruleId) throws PortalException {
        MDRRule rule = this.mdrRuleLocalService.fetchRule(ruleId);
        if (rule != null) {
            this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), rule.getRuleGroupId(), "VIEW");
        }
        return rule;
    }

    public MDRRule getRule(long ruleId) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), rule.getRuleGroupId(), "VIEW");
        return rule;
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), rule.getRuleGroupId(), "UPDATE");
        return this.mdrRuleLocalService.updateRule(ruleId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), rule.getRuleGroupId(), "UPDATE");
        return this.mdrRuleLocalService.updateRule(ruleId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
    }
}

