/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.mobile.device.rules.model.impl;

import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalServiceUtil;

/**
 * The extended model base implementation for the MDRRuleGroupInstance service. Represents a row in the &quot;MDRRuleGroupInstance&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MDRRuleGroupInstanceImpl}.
 * </p>
 *
 * @author Edward C. Han
 * @see MDRRuleGroupInstanceImpl
 * @see MDRRuleGroupInstance
 * @generated
 */
public abstract class MDRRuleGroupInstanceBaseImpl
	extends MDRRuleGroupInstanceModelImpl implements MDRRuleGroupInstance {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mdr rule group instance model instance should use the <code>MDRRuleGroupInstance</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MDRRuleGroupInstanceLocalServiceUtil.addMDRRuleGroupInstance(this);
		}
		else {
			MDRRuleGroupInstanceLocalServiceUtil.updateMDRRuleGroupInstance(
				this);
		}
	}

}