/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microsoft.translator.internal;

import com.liferay.microsoft.translator.internal.MicrosoftTranslatorAuthenticator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslator;
import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslatorException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;

public class MicrosoftTranslatorImpl
implements MicrosoftTranslator {
    private final MicrosoftTranslatorAuthenticator _microsoftTranslatorAuthenticator;

    public MicrosoftTranslatorImpl(String subscriptionKey) {
        this._microsoftTranslatorAuthenticator = new MicrosoftTranslatorAuthenticator(subscriptionKey);
    }

    public MicrosoftTranslatorAuthenticator getMicrosoftTranslatorAuthenticator() {
        return this._microsoftTranslatorAuthenticator;
    }

    public String translate(String fromLanguageId, String toLanguageId, String fromText) throws MicrosoftTranslatorException {
        try {
            return this.doTranslate(fromLanguageId, toLanguageId, fromText);
        }
        catch (MicrosoftTranslatorException mte) {
            throw mte;
        }
        catch (Exception e) {
            throw new MicrosoftTranslatorException((Throwable)e);
        }
    }

    protected String doTranslate(String fromLanguageId, String toLanguageId, String fromText) throws Exception {
        fromLanguageId = this.getMicrosoftLanguageId(fromLanguageId);
        toLanguageId = this.getMicrosoftLanguageId(toLanguageId);
        Http.Options options = new Http.Options();
        StringBundler sb = new StringBundler(7);
        sb.append("https://api.microsofttranslator.com/v2/http.svc/Translate?");
        sb.append("text=");
        sb.append(URLCodec.encodeURL((String)fromText));
        sb.append("&from=");
        sb.append(fromLanguageId);
        sb.append("&to=");
        sb.append(toLanguageId);
        options.setLocation(sb.toString());
        String accessToken = this._microsoftTranslatorAuthenticator.getAccessToken();
        if (Validator.isNull((String)accessToken)) {
            throw new MicrosoftTranslatorException(this._microsoftTranslatorAuthenticator.getError());
        }
        options.addHeader("Authorization", "Bearer " + accessToken);
        String text = HttpUtil.URLtoString((Http.Options)options);
        int x = text.indexOf(">") + 1;
        int y = text.indexOf("</string>", x);
        if (x == -1 || y == -1) {
            x = text.indexOf("Message: ");
            y = text.indexOf("<", x);
            if (x > -1 && y > -1) {
                text = text.substring(x, y);
            }
            throw new MicrosoftTranslatorException(text);
        }
        String toText = text.substring(x, y);
        toText = toText.trim();
        return StringUtil.replace((String)toText, (char)'\n', (char)' ');
    }

    protected String getMicrosoftLanguageId(String languageId) {
        if (languageId.equals("pt_BR") || languageId.equals("pt_PT")) {
            return "pt";
        }
        if (languageId.equals("hi_IN")) {
            return "hi";
        }
        if (languageId.equals("in")) {
            return "id";
        }
        if (languageId.equals("iw")) {
            return "he";
        }
        if (languageId.equals("nb")) {
            return "no";
        }
        if (languageId.equals("zh_CN")) {
            return "zh-CHS";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-CHT";
        }
        return languageId;
    }
}

