/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.internal.util;

import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.comparator.UserFirstNameComparator;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class MicroblogsUtil {
    private static final Log _log = LogFactoryUtil.getLog(MicroblogsUtil.class);
    private static final Pattern _hashtagPattern = Pattern.compile("\\#[a-zA-Z]\\w*");
    private static final Pattern _userTagPattern = Pattern.compile("\\[\\@\\S*\\]");

    public static List<String> getHashtags(String content) {
        ArrayList<String> hashtags = new ArrayList<String>();
        Matcher matcher = _hashtagPattern.matcher(content);
        while (matcher.find()) {
            String hashtag = matcher.group();
            hashtag = hashtag.substring(1);
            hashtags.add(hashtag);
        }
        return hashtags;
    }

    public static int getNotificationType(MicroblogsEntry microblogsEntry, long userId, int deliveryType) throws PortalException {
        if (MicroblogsUtil.isTaggedUser(microblogsEntry.getMicroblogsEntryId(), false, userId) && UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)0L, (int)3, (int)deliveryType)) {
            return 3;
        }
        if (microblogsEntry.getType() == 1) {
            long rootMicroblogsEntryId = MicroblogsUtil.getRootMicroblogsEntryId(microblogsEntry);
            if (MicroblogsUtil.getRootMicroblogsUserId(microblogsEntry) == userId && UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)0L, (int)0, (int)deliveryType)) {
                return 0;
            }
            if (MicroblogsUtil.hasReplied(rootMicroblogsEntryId, userId) && UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)0L, (int)1, (int)deliveryType)) {
                return 1;
            }
            if (MicroblogsUtil.isTaggedUser(rootMicroblogsEntryId, true, userId) && UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)0L, (int)2, (int)deliveryType)) {
                return 2;
            }
        }
        return -1;
    }

    public static String getProcessedContent(MicroblogsEntry microblogsEntry, ServiceContext serviceContext) throws PortalException {
        return MicroblogsUtil.getProcessedContent(microblogsEntry.getContent(), serviceContext);
    }

    public static String getProcessedContent(String content, ServiceContext serviceContext) throws PortalException {
        content = MicroblogsUtil._replaceHashtags(content, serviceContext);
        content = MicroblogsUtil._replaceUserTags(content, serviceContext);
        return content;
    }

    public static JSONArray getRecipientsJSONArray(long userId, ThemeDisplay themeDisplay) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List users = UserLocalServiceUtil.getSocialUsers((long)userId, (long)12L, (int)-1, (int)-1, (OrderByComparator)new UserFirstNameComparator(true));
        for (User user : users) {
            if (user.isGuestUser() || userId == user.getUserId()) continue;
            jsonArray.put(JSONUtil.put((String)"emailAddress", (Object)user.getEmailAddress()).put("fullName", user.getFullName()).put("jobTitle", user.getJobTitle()).put("portraitURL", user.getPortraitURL(themeDisplay)).put("screenName", user.getScreenName()).put("userId", user.getUserId()));
        }
        return jsonArray;
    }

    public static long getRootMicroblogsEntryId(MicroblogsEntry microblogsEntry) {
        if (microblogsEntry.getType() == 2) {
            return microblogsEntry.getMicroblogsEntryId();
        }
        return microblogsEntry.getParentMicroblogsEntryId();
    }

    public static long getRootMicroblogsUserId(MicroblogsEntry microblogsEntry) throws PortalException {
        if (microblogsEntry.getType() == 2) {
            return microblogsEntry.getUserId();
        }
        return microblogsEntry.getParentMicroblogsEntryUserId();
    }

    public static List<String> getScreenNames(String content) {
        ArrayList<String> screenNames = new ArrayList<String>();
        Matcher matcher = _userTagPattern.matcher(content);
        while (matcher.find()) {
            String screenName = matcher.group();
            screenName = StringUtil.removeSubstring((String)screenName, (String)"[@");
            screenName = StringUtil.replace((String)screenName, (char)']', (String)"");
            screenNames.add(screenName);
        }
        return screenNames;
    }

    public static List<Long> getSubscriberUserIds(MicroblogsEntry microblogsEntry) {
        ArrayList<Long> receiverUserIds = new ArrayList<Long>();
        List subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)microblogsEntry.getCompanyId(), (String)MicroblogsEntry.class.getName(), (long)MicroblogsUtil.getRootMicroblogsEntryId(microblogsEntry));
        for (Subscription subscription : subscriptions) {
            if (microblogsEntry.getUserId() == subscription.getUserId()) continue;
            receiverUserIds.add(subscription.getUserId());
        }
        return receiverUserIds;
    }

    public static boolean hasReplied(long parentMicroblogsEntryId, long userId) throws PortalException {
        ArrayList<MicroblogsEntry> microblogsEntries = new ArrayList<MicroblogsEntry>();
        microblogsEntries.addAll(MicroblogsEntryLocalServiceUtil.getParentMicroblogsEntryMicroblogsEntries((int)1, (long)parentMicroblogsEntryId, (int)-1, (int)-1));
        microblogsEntries.add(MicroblogsEntryLocalServiceUtil.getMicroblogsEntry((long)parentMicroblogsEntryId));
        for (MicroblogsEntry microblogsEntry : microblogsEntries) {
            if (microblogsEntry.getUserId() != userId) continue;
            return true;
        }
        return false;
    }

    public static boolean isTaggedUser(long microblogsEntryId, boolean checkParent, long userId) throws PortalException {
        MicroblogsEntry microblogsEntry = MicroblogsEntryLocalServiceUtil.fetchMicroblogsEntry((long)microblogsEntryId);
        if (microblogsEntry == null) {
            return false;
        }
        if (!checkParent) {
            return MicroblogsUtil.isTaggedUser(microblogsEntry, userId);
        }
        long rootMicroblogsEntryId = MicroblogsUtil.getRootMicroblogsEntryId(microblogsEntry);
        ArrayList<MicroblogsEntry> microblogsEntries = new ArrayList<MicroblogsEntry>();
        microblogsEntries.addAll(MicroblogsEntryLocalServiceUtil.getParentMicroblogsEntryMicroblogsEntries((int)1, (long)rootMicroblogsEntryId, (int)-1, (int)-1));
        microblogsEntries.add(MicroblogsEntryLocalServiceUtil.getMicroblogsEntry((long)rootMicroblogsEntryId));
        for (MicroblogsEntry curMicroblogsEntry : microblogsEntries) {
            if (!MicroblogsUtil.isTaggedUser(curMicroblogsEntry, userId)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTaggedUser(MicroblogsEntry microblogsEntry, long userId) throws PortalException {
        List<String> screenNames = MicroblogsUtil.getScreenNames(microblogsEntry.getContent());
        for (String screenName : screenNames) {
            long screenNameUserId = UserLocalServiceUtil.getUserIdByScreenName((long)microblogsEntry.getCompanyId(), (String)screenName);
            if (screenNameUserId != userId) continue;
            return true;
        }
        return false;
    }

    private static String _replaceHashtags(String content, ServiceContext serviceContext) throws PortalException {
        String escapedContent = HtmlUtil.escape((String)content);
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        Matcher matcher = _hashtagPattern.matcher(content);
        while (matcher.find()) {
            LiferayPortletURL portletURL;
            StringBundler sb;
            String result;
            block7: {
                result = matcher.group();
                sb = new StringBundler(6);
                sb.append("<span class=\"hashtag\">#</span>");
                sb.append("<a class=\"hashtag-link\" href=\"");
                portletURL = null;
                Group group = GroupLocalServiceUtil.getUserGroup((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId());
                long portletPlid = PortalUtil.getPlidFromPortletId((long)group.getGroupId(), (boolean)true, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet");
                if (portletPlid != 0L) {
                    portletURL = PortletURLFactoryUtil.create((PortletRequest)serviceContext.getLiferayPortletRequest(), (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)portletPlid, (String)"RENDER_PHASE");
                    try {
                        portletURL.setWindowState(LiferayWindowState.NORMAL);
                    }
                    catch (WindowStateException windowStateException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)windowStateException);
                        }
                        break block7;
                    }
                }
                LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
                portletURL = liferayPortletResponse.createRenderURL("com_liferay_microblogs_web_portlet_MicroblogsPortlet");
                try {
                    portletURL.setWindowState(WindowState.MAXIMIZED);
                }
                catch (WindowStateException windowStateException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Throwable)windowStateException);
                }
            }
            portletURL.setParameter("mvcPath", "/microblogs/view.jsp");
            String assetTagName = result.substring(1);
            portletURL.setParameter("tabs1", assetTagName);
            portletURL.setParameter("assetTagName", assetTagName);
            sb.append((Object)portletURL);
            sb.append("\">");
            sb.append(assetTagName);
            sb.append("</a>");
            String tagLink = sb.toString();
            escapedContent = StringUtil.replace((String)escapedContent, (String)result, (String)tagLink);
        }
        return escapedContent;
    }

    private static String _replaceUserTags(String content, ServiceContext serviceContext) throws PortalException {
        Matcher matcher = _userTagPattern.matcher(content);
        while (matcher.find()) {
            String result = matcher.group();
            try {
                StringBundler sb = new StringBundler(5);
                sb.append("<a href=\"");
                String assetTagScreenName = StringUtil.removeSubstring((String)result, (String)"[@");
                assetTagScreenName = StringUtil.replace((String)assetTagScreenName, (char)']', (String)"");
                ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
                User assetTagUser = UserLocalServiceUtil.getUserByScreenName((long)themeDisplay.getCompanyId(), (String)assetTagScreenName);
                sb.append(assetTagUser.getDisplayURL(themeDisplay));
                sb.append("\">");
                String assetTagUserName = PortalUtil.getUserName((long)assetTagUser.getUserId(), (String)assetTagScreenName);
                sb.append(assetTagUserName);
                sb.append("</a>");
                String userLink = sb.toString();
                content = StringUtil.replace((String)content, (String)result, (String)userLink);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchUserException);
            }
        }
        return content;
    }
}

