/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBDiscussionLocalServiceUtil;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import java.util.List;

public class MBDiscussionStagingHandler
implements DiscussionStagingHandler {
    public <T extends StagedModel> void exportReferenceDiscussions(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        GroupedModel groupedModel;
        MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.fetchDiscussion((String)ExportImportClassedModelUtil.getClassName(stagedModel), (long)ExportImportClassedModelUtil.getClassPK(stagedModel));
        if (mbDiscussion == null) {
            return;
        }
        if (stagedModel instanceof GroupedModel && ((groupedModel = (GroupedModel)stagedModel).getGroupId() != portletDataContext.getGroupId() || groupedModel.getGroupId() != mbDiscussion.getGroupId())) {
            return;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)mbDiscussion.getGroupId());
        if (group != null && group.isControlPanel()) {
            return;
        }
        List mbMessages = MBMessageLocalServiceUtil.getThreadMessages((long)mbDiscussion.getThreadId(), (int)0);
        if (mbMessages.isEmpty()) {
            return;
        }
        MBMessage firstMBMessage = (MBMessage)mbMessages.get(0);
        if (mbMessages.size() == 1 && firstMBMessage.isRoot()) {
            return;
        }
        for (MBMessage mbMessage : mbMessages) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, stagedModel, (StagedModel)mbMessage, (String)"weak");
        }
    }

    public String getClassName() {
        Class<? extends StagedModel> stagedModelClass = this.getStagedModelClass();
        return stagedModelClass.getName();
    }

    public ActionableDynamicQuery getCommentExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = MBMessageLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
            Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
            if (modifiedDateCriterion != null && statusDateCriterion != null) {
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(modifiedDateCriterion);
                disjunction.add(statusDateCriterion);
                dynamicQuery.add((Criterion)disjunction);
            }
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.gt((Object)0L));
            Property parentMessageIdProperty = PropertyFactoryUtil.forName((String)"parentMessageId");
            dynamicQuery.add(parentMessageIdProperty.gt((Object)0L));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            if (portletDataContext.isInitialPublication()) {
                dynamicQuery.add(statusProperty.ne((Object)8));
            } else {
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)MBMessage.class.getName());
                dynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            }
        });
        return actionableDynamicQuery;
    }

    public String getResourceName() {
        return "com.liferay.message.boards";
    }

    public Class<? extends StagedModel> getStagedModelClass() {
        return MBMessage.class;
    }

    public <T extends StagedModel> void importReferenceDiscussions(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, stagedModel, MBMessage.class);
    }
}

