/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.comment.constants.CommentConstants;
import com.liferay.message.boards.comment.internal.MBCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionPermissionImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionStagingHandler;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.util.comparator.MessageThreadComparator;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommentManager.class})
public class MBCommentManagerImpl
implements CommentManager {
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;

    public long addComment(long userId, long groupId, String className, long classPK, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread thread = messageDisplay.getThread();
        List messages = this._mbMessageLocalService.getThreadMessages(thread.getThreadId(), 0);
        for (MBMessage message : messages) {
            String messageBody = message.getBody();
            if (!messageBody.equals(body)) continue;
            throw new DuplicateCommentException(body);
        }
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, "", groupId, className, classPK, thread.getThreadId(), thread.getRootMessageId(), "", body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay mbMessageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread mbThread = mbMessageDisplay.getThread();
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, mbThread.getThreadId(), mbThread.getRootMessageId(), subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(long userId, String className, long classPK, String userName, long parentCommentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessage parentMessage = this._mbMessageLocalService.getMessage(parentCommentId);
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, userName, parentMessage.getGroupId(), className, classPK, parentMessage.getThreadId(), parentCommentId, subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, 1);
    }

    public void deleteComment(long commentId) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessage(commentId);
    }

    public void deleteDiscussion(String className, long classPK) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessages(className, classPK);
    }

    public void deleteGroupComments(long groupId) throws PortalException {
        this._mbThreadLocalService.deleteThreads(groupId, -1L);
    }

    public Comment fetchComment(long commentId) {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(commentId);
        if (mbMessage == null) {
            return null;
        }
        return new MBCommentImpl(mbMessage);
    }

    public DiscussionComment fetchDiscussionComment(long userId, long commentId) throws PortalException {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(commentId);
        if (mbMessage == null) {
            return null;
        }
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, mbMessage.getGroupId(), mbMessage.getClassName(), mbMessage.getClassPK(), -1, (Comparator)new MessageThreadComparator());
        return this.getDiscussionComment(userId, messageDisplay);
    }

    public List<Comment> getChildComments(long parentCommentId, int status, int start, int end) {
        return Stream.of(this._mbMessageLocalService.getChildMessages(parentCommentId, status, start, end)).flatMap(Collection::stream).map(MBCommentImpl::new).collect(Collectors.toList());
    }

    public int getChildCommentsCount(long parentCommentId, int status) {
        return this._mbMessageLocalService.getChildMessagesCount(parentCommentId, status);
    }

    public int getCommentsCount(String className, long classPK) {
        long classNameId = this._portal.getClassNameId(className);
        return this._mbMessageLocalService.getDiscussionMessagesCount(classNameId, classPK, 0);
    }

    public Discussion getDiscussion(long userId, long groupId, String className, long classPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, -1, (Comparator)new MessageThreadComparator());
        DiscussionComment rootDiscussionComment = this.getDiscussionComment(userId, messageDisplay);
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        List messages = treeWalker.getMessages();
        return new MBDiscussionImpl(rootDiscussionComment, messageDisplay.isDiscussionMaxComments(), messages.size() - 1);
    }

    public DiscussionPermission getDiscussionPermission(PermissionChecker permissionChecker) {
        return new MBDiscussionPermissionImpl(permissionChecker);
    }

    public DiscussionStagingHandler getDiscussionStagingHandler() {
        return new MBDiscussionStagingHandler();
    }

    public List<Comment> getRootComments(String className, long classPK, int status, int start, int end) throws PortalException {
        return Stream.of(this._mbMessageLocalService.getRootDiscussionMessages(className, classPK, status, start, end)).flatMap(Collection::stream).map(MBCommentImpl::new).collect(Collectors.toList());
    }

    public int getRootCommentsCount(String className, long classPK, int status) {
        return this._mbMessageLocalService.getRootDiscussionMessagesCount(className, classPK, status);
    }

    public boolean hasDiscussion(String className, long classPK) {
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(className, classPK);
        return discussion != null;
    }

    public void moveDiscussionToTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 0);
        for (MBMessage message : messages) {
            message.setStatus(8);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    public void restoreDiscussionFromTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 8);
        for (MBMessage message : messages) {
            message.setStatus(0);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    public void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.subscribeDiscussion(userId, groupId, className, classPK);
    }

    public void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.unsubscribeDiscussion(userId, className, classPK);
    }

    public long updateComment(long userId, String className, long classPK, long commentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage message = this._mbMessageLocalService.updateDiscussionMessage(userId, commentId, className, classPK, subject, body, serviceContext);
        return message.getMessageId();
    }

    protected DiscussionComment getDiscussionComment(long userId, MBMessageDisplay messageDisplay) {
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        List messages = treeWalker.getMessages();
        ArrayList<Long> classPKs = new ArrayList<Long>();
        if (messages.size() > 1) {
            for (MBMessage curMessage : messages) {
                if (curMessage.isRoot()) continue;
                classPKs.add(curMessage.getMessageId());
            }
        }
        if (classPKs.isEmpty()) {
            return new MBDiscussionCommentImpl(treeWalker.getRoot(), treeWalker, Collections.emptyMap(), Collections.emptyMap());
        }
        long[] classPKsArray = ArrayUtil.toLongArray(classPKs);
        Map ratingsEntries = null;
        Map ratingsStats = this._ratingsStatsLocalService.getStats(CommentConstants.getDiscussionClassName(), classPKsArray);
        ratingsEntries = ratingsStats.isEmpty() ? Collections.emptyMap() : this._ratingsEntryLocalService.getEntries(userId, CommentConstants.getDiscussionClassName(), classPKsArray);
        return new MBDiscussionCommentImpl(treeWalker.getRoot(), treeWalker, ratingsEntries, ratingsStats);
    }
}

