/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.impl;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.service.base.AttachmentLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.mail.reader.model.Attachment"}, service={AopService.class})
public class AttachmentLocalServiceImpl
extends AttachmentLocalServiceBaseImpl {
    private static final String _DIRECTORY_PATH_PREFIX = "mail/";
    private static final long _REPOSITORY_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(AttachmentLocalServiceImpl.class);

    public Attachment addAttachment(long userId, long messageId, String contentPath, String fileName, long size, File file) throws PortalException {
        Attachment attachment;
        block4: {
            User user = this.userLocalService.getUser(userId);
            Message message = this.messagePersistence.findByPrimaryKey(messageId);
            long attachmentId = this.counterLocalService.increment();
            attachment = this.attachmentPersistence.create(attachmentId);
            attachment.setCompanyId(user.getCompanyId());
            attachment.setUserId(user.getUserId());
            attachment.setAccountId(message.getAccountId());
            attachment.setFolderId(message.getFolderId());
            attachment.setMessageId(messageId);
            attachment.setContentPath(contentPath);
            attachment.setFileName(fileName);
            attachment.setSize(size);
            attachment = (Attachment)this.attachmentPersistence.update((BaseModel)attachment);
            if (file != null) {
                if (!file.exists()) {
                    throw new PortalException((Throwable)new FileNotFoundException());
                }
                String filePath = this.getFilePath(attachment.getMessageId(), fileName);
                try {
                    DLStoreUtil.addFile((long)attachment.getCompanyId(), (long)0L, (String)filePath, (File)file);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
            }
        }
        return attachment;
    }

    @Override
    public Attachment deleteAttachment(long attachmentId) throws PortalException {
        Attachment attachment = this.attachmentPersistence.findByPrimaryKey(attachmentId);
        this.attachmentPersistence.remove(attachmentId);
        String filePath = this.getFilePath(attachment.getMessageId(), attachment.getFileName());
        DLStoreUtil.deleteFile((long)attachment.getCompanyId(), (long)0L, (String)filePath);
        return attachment;
    }

    public void deleteAttachments(long companyId, long messageId) throws PortalException {
        List attachments = this.attachmentPersistence.findByMessageId(messageId);
        for (Attachment attachment : attachments) {
            this.deleteAttachment(attachment);
        }
        DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)this.getDirectoryPath(messageId));
    }

    public List<Attachment> getAttachments(long messageId) {
        return this.attachmentPersistence.findByMessageId(messageId);
    }

    public File getFile(long attachmentId) throws PortalException {
        try {
            File file = FileUtil.createTempFile();
            FileUtil.write((File)file, (InputStream)this.getInputStream(attachmentId));
            return file;
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public InputStream getInputStream(long attachmentId) throws PortalException {
        Attachment attachment = this.attachmentPersistence.findByPrimaryKey(attachmentId);
        String filePath = this.getFilePath(attachment.getMessageId(), attachment.getFileName());
        return DLStoreUtil.getFileAsStream((long)attachment.getCompanyId(), (long)0L, (String)filePath);
    }

    protected String getDirectoryPath(long messageId) {
        return _DIRECTORY_PATH_PREFIX.concat(String.valueOf(messageId));
    }

    protected String getFilePath(long messageId, String fileName) {
        return StringBundler.concat((String[])new String[]{this.getDirectoryPath(messageId), "/", fileName});
    }
}

