/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.imap;

import com.liferay.mail.reader.configuration.MailGroupServiceConfiguration;
import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.model.Account;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.time.StopWatch;

public class IMAPConnection {
    private static final Log _log = LogFactoryUtil.getLog(IMAPConnection.class);
    private static final ConcurrentHashMap<String, Store> _allStores = new ConcurrentHashMap();
    private final String _incomingHostName;
    private final int _incomingPort;
    private final boolean _incomingSecure;
    private final String _login;
    private MailGroupServiceConfiguration _mailGroupServiceConfiguration;
    private final String _outgoingHostName;
    private final int _outgoingPort;
    private final boolean _outgoingSecure;
    private final String _password;
    private Session _session;

    public IMAPConnection(Account account, String password) {
        this(account.getIncomingHostName(), account.getIncomingPort(), account.isIncomingSecure(), account.getOutgoingHostName(), account.getOutgoingPort(), account.isOutgoingSecure(), account.getLogin(), password);
    }

    public IMAPConnection(String incomingHostName, int incomingPort, boolean incomingSecure, String outgoingHostName, int outgoingPort, boolean outgoingSecure, String login, String password) {
        this._incomingHostName = incomingHostName;
        this._incomingPort = incomingPort;
        this._incomingSecure = incomingSecure;
        this._outgoingHostName = outgoingHostName;
        this._outgoingPort = outgoingPort;
        this._outgoingSecure = outgoingSecure;
        this._login = login;
        this._password = password;
    }

    public Session getSession() {
        if (this._session != null) {
            return this._session;
        }
        Properties properties = new Properties();
        properties.put("mail.debug", String.valueOf(this.isJavaMailDebug()));
        properties.put("mail.imap.host", this._incomingHostName);
        properties.put("mail.imap.port", (Object)this._incomingPort);
        properties.put("mail.imaps.auth", "true");
        properties.put("mail.imaps.host", this._incomingHostName);
        properties.put("mail.imaps.port", (Object)this._incomingPort);
        properties.put("mail.imaps.socketFactory.class", SSLSocketFactory.class.getName());
        properties.put("mail.imaps.socketFactory.fallback", "false");
        properties.put("mail.imaps.socketFactory.port", (Object)this._incomingPort);
        properties.put("mail.smtp.host", this._outgoingHostName);
        properties.put("mail.smtp.port", (Object)this._outgoingPort);
        properties.put("mail.smtps.auth", "true");
        properties.put("mail.smtps.host", this._outgoingHostName);
        properties.put("mail.smtps.port", (Object)this._outgoingPort);
        properties.put("mail.smtps.socketFactory.class", SSLSocketFactory.class.getName());
        properties.put("mail.smtps.socketFactory.fallback", "false");
        properties.put("mail.smtps.socketFactory.port", (Object)this._outgoingPort);
        this._session = Session.getInstance((Properties)properties);
        this._session.setDebug(this.isJavaMailDebug());
        return this._session;
    }

    public Store getStore(boolean useOldStores) throws MailException {
        Store store = null;
        try {
            String storeKey = StringBundler.concat((String[])new String[]{this._incomingHostName, this._outgoingHostName, this._login});
            if (useOldStores && (store = _allStores.get(storeKey)) != null && !store.isConnected()) {
                store.close();
                store = null;
            }
            if (store == null) {
                Session session = this.getSession();
                store = this._incomingSecure ? session.getStore("imaps") : session.getStore("imap");
                store.connect(this._incomingHostName, this._incomingPort, this._login, this._password);
                if (useOldStores) {
                    _allStores.put(storeKey, store);
                }
            }
            return store;
        }
        catch (MessagingException messagingException) {
            throw new MailException(3, (Throwable)messagingException);
        }
    }

    public Transport getTransport() throws MailException {
        Transport transport = null;
        try {
            Session session = this.getSession();
            transport = this._outgoingSecure ? session.getTransport("smtps") : session.getTransport("smtp");
            transport.connect(this._outgoingHostName, this._outgoingPort, this._login, this._password);
            return transport;
        }
        catch (MessagingException messagingException) {
            throw new MailException(4, (Throwable)messagingException);
        }
    }

    public void testConnection() throws MailException {
        MailException mailException1 = null;
        boolean failedIncomingConnection = false;
        try {
            this.testIncomingConnection();
        }
        catch (MailException mailException2) {
            mailException1 = mailException2;
            failedIncomingConnection = true;
        }
        boolean failedOutgoingConnection = false;
        try {
            this.testOutgoingConnection();
        }
        catch (MailException mailException2) {
            mailException1 = mailException2;
            failedOutgoingConnection = true;
        }
        if (failedIncomingConnection && failedOutgoingConnection) {
            throw new MailException(2, (Throwable)mailException1);
        }
        if (failedIncomingConnection) {
            throw new MailException(3, (Throwable)mailException1);
        }
        if (failedOutgoingConnection) {
            throw new MailException(4, (Throwable)mailException1);
        }
    }

    protected boolean isJavaMailDebug() {
        if (this._mailGroupServiceConfiguration == null) {
            long companyId = PortalUtil.getDefaultCompanyId();
            try {
                this._mailGroupServiceConfiguration = (MailGroupServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(MailGroupServiceConfiguration.class, (long)companyId);
            }
            catch (ConfigurationException configurationException) {
                _log.error((Object)"Unable to get mail configuration", (Throwable)configurationException);
            }
        }
        return this._mailGroupServiceConfiguration.javamailDebug();
    }

    protected void testIncomingConnection() throws MailException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Store store = this.getStore(false);
            store.close();
        }
        catch (Exception exception) {
            throw new MailException(3, (Throwable)exception);
        }
        finally {
            if (_log.isDebugEnabled()) {
                stopWatch.stop();
                _log.debug((Object)("Testing incoming connection completed in " + stopWatch.getTime() + " ms"));
            }
        }
    }

    protected void testOutgoingConnection() throws MailException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Transport transport = this.getTransport();
            transport.isConnected();
            transport.close();
        }
        catch (Exception exception) {
            throw new MailException(4, (Throwable)exception);
        }
        finally {
            if (_log.isDebugEnabled()) {
                stopWatch.stop();
                _log.debug((Object)("Testing outgoing connection completed in " + stopWatch.getTime() + " ms"));
            }
        }
    }
}

