/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlContentUtil {
    private static final Pattern _bodyTagPattern = Pattern.compile("</?body[^>]+>", 2);
    private static final Pattern _doctypeTagPattern = Pattern.compile("<!doctype[^>]+>", 2);
    private static final Pattern _headTagPattern = Pattern.compile("<head.*?</head>", 34);
    private static final Pattern _htmlTagPattern = Pattern.compile("</?html[^>]+>", 2);
    private static final Pattern _lineBreakPattern = Pattern.compile("[\r\n]+");
    private static final Pattern _linkTagPattern = Pattern.compile("</?link[^>]+>", 2);
    private static final Pattern _scriptTagPattern = Pattern.compile("<script.*?</script>", 34);
    private static final Pattern _styleTagPattern = Pattern.compile("<style.*?</style>", 34);
    private static final Pattern _tagPattern = Pattern.compile("<[^>]+>");

    public static String getInlineHtml(String html) {
        Matcher matcher = _bodyTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _doctypeTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _htmlTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _linkTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _headTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _scriptTagPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _styleTagPattern.matcher(html);
        return matcher.replaceAll("");
    }

    public static String getPlainText(String html) {
        Matcher matcher = _lineBreakPattern.matcher(html);
        html = matcher.replaceAll("");
        matcher = _tagPattern.matcher(html);
        return matcher.replaceAll("");
    }
}

