/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.mailbox;

import com.liferay.mail.reader.mailbox.Mailbox;
import com.liferay.mail.reader.mailbox.MailboxFactory;
import com.liferay.mail.reader.model.Account;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mail_reader_web_portlet_MailPortlet"}, service={MailboxFactoryUtil.class})
public class MailboxFactoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(MailboxFactoryUtil.class);
    private static final ServiceTrackerMap<String, MailboxFactory> _mailboxFactories;

    public static Mailbox getMailbox(User user, Account account, String password) throws PortalException {
        MailboxFactory mailboxFactory = (MailboxFactory)_mailboxFactories.getService((Object)account.getProtocol());
        if (mailboxFactory == null) {
            throw new IllegalArgumentException("Invalid protocol " + account.getProtocol());
        }
        return mailboxFactory.getMailbox(user, account, password);
    }

    public static Mailbox getMailbox(User user, String protocol) throws PortalException {
        MailboxFactory mailboxFactory = (MailboxFactory)_mailboxFactories.getService((Object)protocol);
        if (mailboxFactory == null) {
            throw new IllegalArgumentException("Invalid protocol " + protocol);
        }
        return mailboxFactory.getMailbox(user, protocol);
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(MailboxFactoryUtil.class);
        final BundleContext bundleContext = bundle.getBundleContext();
        _mailboxFactories = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, MailboxFactory.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, MailboxFactory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void map(ServiceReference<MailboxFactory> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                MailboxFactory mailboxFactory = (MailboxFactory)bundleContext.getService(serviceReference);
                try {
                    mailboxFactory.initialize();
                    emitter.emit((Object)mailboxFactory.getMailboxFactoryName());
                }
                catch (PortalException pe) {
                    _log.error((Object)"Unable to initialize mail box factory", (Throwable)pe);
                }
                finally {
                    bundleContext.ungetService(serviceReference);
                }
            }
        });
    }
}

