/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_4_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;

public class LayoutUpgradeProcess
extends UpgradeProcess {
    private final LayoutLocalService _layoutLocalService;

    public LayoutUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select groupId, plid, friendlyUrl from Layout where ", "privateLayout = ? and (plid IN (select plid from ", "LayoutPageTemplateEntry where type_ = ?) OR (classPK IN (", "select plid from LayoutPageTemplateEntry where type_ = ?", ") and classNameId = ?))"}));
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select plid from Layout where privateLayout = ? and groupId = ? and friendlyUrl = ? and plid != ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Layout set uuid_ = ?, friendlyUrl = ? where plid = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutFriendlyURL set friendlyUrl = ? where plid = ?");
             PreparedStatement preparedStatement5 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Layout set privateLayout = ?, layoutId = ? where plid = ?");
             PreparedStatement preparedStatement6 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutFriendlyURL set privateLayout = ? where plid = ?");){
            preparedStatement1.setBoolean(1, false);
            preparedStatement1.setLong(2, 3L);
            preparedStatement1.setLong(3, 3L);
            preparedStatement1.setLong(4, PortalUtil.getClassNameId((String)Layout.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long plid = resultSet.getLong("plid");
                    String friendlyUrl = resultSet.getString("friendlyUrl");
                    preparedStatement2.setBoolean(1, true);
                    preparedStatement2.setLong(2, groupId);
                    preparedStatement2.setString(3, friendlyUrl);
                    preparedStatement2.setLong(4, plid);
                    try (ResultSet resultSet1 = preparedStatement2.executeQuery();){
                        while (resultSet1.next()) {
                            long duplicationPlid = resultSet1.getLong("plid");
                            String newFriendlyUrl = this._generateFriendlyURLUUID();
                            preparedStatement3.setString(1, this._generateUUID());
                            preparedStatement3.setString(2, newFriendlyUrl);
                            preparedStatement3.setLong(3, duplicationPlid);
                            preparedStatement3.addBatch();
                            preparedStatement4.setString(1, newFriendlyUrl);
                            preparedStatement4.setLong(2, duplicationPlid);
                            preparedStatement4.addBatch();
                        }
                    }
                    preparedStatement5.setBoolean(1, true);
                    preparedStatement5.setLong(2, this._layoutLocalService.getNextLayoutId(groupId, true));
                    preparedStatement5.setLong(3, plid);
                    preparedStatement5.addBatch();
                    preparedStatement6.setBoolean(1, true);
                    preparedStatement6.setLong(2, plid);
                    preparedStatement6.addBatch();
                }
            }
            preparedStatement3.executeBatch();
            preparedStatement4.executeBatch();
            preparedStatement5.executeBatch();
            preparedStatement6.executeBatch();
        }
    }

    private String _generateFriendlyURLUUID() {
        return "/" + this._generateUUID();
    }

    private String _generateUUID() {
        UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
        return uuid.toString();
    }
}

