/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_4_4;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.constants.FeatureFlagConstants;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import java.util.Objects;
import org.osgi.service.cm.ConfigurationAdmin;

public class LayoutPrivateLayoutsUpgradeProcess
extends UpgradeProcess {
    private static final String _DISABLE_PRIVATE_LAYOUTS = "DISABLE_PRIVATE_LAYOUTS";
    private static final Version _VERSION = Version.parseVersion((String)"1.0.0");
    private static final Log _log = LogFactoryUtil.getLog(LayoutPrivateLayoutsUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationAdmin _configurationAdmin;
    private final PortalPreferencesLocalService _portalPreferencesLocalService;

    public LayoutPrivateLayoutsUpgradeProcess(CompanyLocalService companyLocalService, ConfigurationAdmin configurationAdmin, PortalPreferencesLocalService portalPreferencesLocalService) {
        this._companyLocalService = companyLocalService;
        this._configurationAdmin = configurationAdmin;
        this._portalPreferencesLocalService = portalPreferencesLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String value = this._getValue();
            this._companyLocalService.forEachCompanyId(companyId -> {
                try {
                    PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)this._portalPreferencesLocalService.getPreferences(companyId.longValue(), 1);
                    PortalPreferencesImpl portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
                    portalPreferences.setValue(FeatureFlagConstants.PREFERENCE_NAMESPACE, "LPD-38869", value);
                    this._portalPreferencesLocalService.updatePreferences(companyId.longValue(), 1, (PortalPreferences)portalPreferences);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            });
        }
    }

    private String _getValue() throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=com.liferay.release.feature.flag.web.internal.configuration.", "ReleaseFeatureFlagConfiguration)"}));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            if (!this._hasReleaseSchemaVersion()) {
                return Boolean.TRUE.toString();
            }
            return Boolean.FALSE.toString();
        }
        Object configuration = configurations[0];
        Dictionary dictionary = configuration.getProperties();
        Object[] disabledReleaseFeatureFlags = (String[])dictionary.get("disabledReleaseFeatureFlags");
        if (ArrayUtil.isNotEmpty((Object[])disabledReleaseFeatureFlags) && Objects.equals(disabledReleaseFeatureFlags[0], _DISABLE_PRIVATE_LAYOUTS)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private boolean _hasReleaseSchemaVersion() throws Exception {
        block16: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select schemaVersion from Release_ where servletContextName = 'com.liferay.release.feature.flag.web'");){
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    boolean bl = false;
                    return bl;
                }
                Version version = Version.parseVersion((String)resultSet.getString("schemaVersion"));
                if (_VERSION.compareTo(version) > 0) break block16;
                boolean bl = true;
                return bl;
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return false;
    }
}

