/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_2_2;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;

public class LayoutSEOUpgradeProcess
extends UpgradeProcess {
    private static final String[] _KEYS = new String[]{"mapped-description", "mapped-openGraphDescription", "mapped-openGraphImage", "mapped-openGraphImageAlt", "mapped-openGraphTitle", "mapped-title"};
    private final LayoutLocalService _layoutLocalService;

    public LayoutSEOUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"asset_display")));
        actionableDynamicQuery.setPerformActionMethod(layout -> this._updateLayoutTypeSettingsProperties((Layout)layout));
        actionableDynamicQuery.performActions();
    }

    private void _updateLayoutTypeSettingsProperties(Layout layout) {
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        for (String key : _KEYS) {
            String value = unicodeProperties.getProperty(key);
            if (!Validator.isNotNull((String)value) || value.startsWith("${")) continue;
            unicodeProperties.setProperty(key, "${" + value + "}");
        }
        layout.setTypeSettingsProperties(unicodeProperties);
        this._layoutLocalService.updateLayout(layout);
    }
}

