/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.launch.service.persistence.impl;

import com.liferay.launch.exception.DuplicateLaunchSetExternalReferenceCodeException;
import com.liferay.launch.exception.NoSuchLaunchSetException;
import com.liferay.launch.model.LaunchSet;
import com.liferay.launch.model.LaunchSetTable;
import com.liferay.launch.model.impl.LaunchSetImpl;
import com.liferay.launch.model.impl.LaunchSetModelImpl;
import com.liferay.launch.service.persistence.LaunchSetPersistence;
import com.liferay.launch.service.persistence.LaunchSetUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LaunchSetPersistence.class})
public class LaunchSetPersistenceImpl
extends BasePersistenceImpl<LaunchSet>
implements LaunchSetPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LaunchSetImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "launchSet.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(launchSet.uuid IS NULL OR launchSet.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "launchSet.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(launchSet.uuid IS NULL OR launchSet.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "launchSet.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "launchSet.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_U;
    private FinderPath _finderPathWithoutPaginationFindByC_U;
    private FinderPath _finderPathCountByC_U;
    private static final String _FINDER_COLUMN_C_U_COMPANYID_2 = "launchSet.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_U_USERID_2 = "launchSet.userId = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private FinderPath _finderPathWithPaginationCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "launchSet.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_STATUS_2 = "launchSet.status = ?";
    private static final String _FINDER_COLUMN_C_S_STATUS_7 = "launchSet.status IN (";
    private FinderPath _finderPathFetchByERC_C;
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2 = "launchSet.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3 = "(launchSet.externalReferenceCode IS NULL OR launchSet.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_C_COMPANYID_2 = "launchSet.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_LAUNCHSET = "SELECT launchSet FROM LaunchSet launchSet";
    private static final String _SQL_SELECT_LAUNCHSET_WHERE = "SELECT launchSet FROM LaunchSet launchSet WHERE ";
    private static final String _SQL_COUNT_LAUNCHSET = "SELECT COUNT(launchSet) FROM LaunchSet launchSet";
    private static final String _SQL_COUNT_LAUNCHSET_WHERE = "SELECT COUNT(launchSet) FROM LaunchSet launchSet WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "launchSet.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LaunchSet exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LaunchSet exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(LaunchSetPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<LaunchSet> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<LaunchSet> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<LaunchSet> findByUuid(String uuid, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByUuid(String uuid, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (uuid.equals(launchSet.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchSet findByUuid_First(String uuid, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByUuid_First(uuid, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByUuid_First(String uuid, OrderByComparator<LaunchSet> orderByComparator) {
        List<LaunchSet> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet findByUuid_Last(String uuid, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByUuid_Last(uuid, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByUuid_Last(String uuid, OrderByComparator<LaunchSet> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<LaunchSet> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet[] findByUuid_PrevAndNext(long launchSetId, String uuid, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        uuid = Objects.toString(uuid, "");
        LaunchSet launchSet = this.findByPrimaryKey(launchSetId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet[] array = new LaunchSetImpl[]{this.getByUuid_PrevAndNext(session, launchSet, uuid, orderByComparator, true), launchSet, this.getByUuid_PrevAndNext(session, launchSet, uuid, orderByComparator, false)};
            LaunchSet[] launchSetArray = array;
            return launchSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet getByUuid_PrevAndNext(Session session, LaunchSet launchSet, String uuid, OrderByComparator<LaunchSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchSet.modifiedDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchSet)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (LaunchSet launchSet : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchSet> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<LaunchSet> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<LaunchSet> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (uuid.equals(launchSet.getUuid()) && companyId == launchSet.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("launchSet.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchSet findByUuid_C_First(String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator) {
        List<LaunchSet> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet findByUuid_C_Last(String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<LaunchSet> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet[] findByUuid_C_PrevAndNext(long launchSetId, String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        uuid = Objects.toString(uuid, "");
        LaunchSet launchSet = this.findByPrimaryKey(launchSetId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet[] array = new LaunchSetImpl[]{this.getByUuid_C_PrevAndNext(session, launchSet, uuid, companyId, orderByComparator, true), launchSet, this.getByUuid_C_PrevAndNext(session, launchSet, uuid, companyId, orderByComparator, false)};
            LaunchSet[] launchSetArray = array;
            return launchSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet getByUuid_C_PrevAndNext(Session session, LaunchSet launchSet, String uuid, long companyId, OrderByComparator<LaunchSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("launchSet.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchSet.modifiedDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchSet)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (LaunchSet launchSet : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("launchSet.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchSet> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<LaunchSet> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<LaunchSet> findByCompanyId(long companyId, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByCompanyId(long companyId, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (companyId == launchSet.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchSet findByCompanyId_First(long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByCompanyId_First(long companyId, OrderByComparator<LaunchSet> orderByComparator) {
        List<LaunchSet> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet findByCompanyId_Last(long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByCompanyId_Last(long companyId, OrderByComparator<LaunchSet> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<LaunchSet> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet[] findByCompanyId_PrevAndNext(long launchSetId, long companyId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.findByPrimaryKey(launchSetId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet[] array = new LaunchSetImpl[]{this.getByCompanyId_PrevAndNext(session, launchSet, companyId, orderByComparator, true), launchSet, this.getByCompanyId_PrevAndNext(session, launchSet, companyId, orderByComparator, false)};
            LaunchSet[] launchSetArray = array;
            return launchSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet getByCompanyId_PrevAndNext(Session session, LaunchSet launchSet, long companyId, OrderByComparator<LaunchSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
        sb.append("launchSet.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchSet.modifiedDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchSet)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (LaunchSet launchSet : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchSet> findByC_U(long companyId, long userId) {
        return this.findByC_U(companyId, userId, -1, -1, null);
    }

    public List<LaunchSet> findByC_U(long companyId, long userId, int start, int end) {
        return this.findByC_U(companyId, userId, start, end, null);
    }

    public List<LaunchSet> findByC_U(long companyId, long userId, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByC_U(companyId, userId, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByC_U(long companyId, long userId, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_U;
                finderArgs = new Object[]{companyId, userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_U;
            finderArgs = new Object[]{companyId, userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (companyId == launchSet.getCompanyId() && userId == launchSet.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_U_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchSet findByC_U_First(long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByC_U_First(companyId, userId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByC_U_First(long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator) {
        List<LaunchSet> list = this.findByC_U(companyId, userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet findByC_U_Last(long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByC_U_Last(companyId, userId, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByC_U_Last(long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator) {
        int count = this.countByC_U(companyId, userId);
        if (count == 0) {
            return null;
        }
        List<LaunchSet> list = this.findByC_U(companyId, userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet[] findByC_U_PrevAndNext(long launchSetId, long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.findByPrimaryKey(launchSetId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet[] array = new LaunchSetImpl[]{this.getByC_U_PrevAndNext(session, launchSet, companyId, userId, orderByComparator, true), launchSet, this.getByC_U_PrevAndNext(session, launchSet, companyId, userId, orderByComparator, false)};
            LaunchSet[] launchSetArray = array;
            return launchSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet getByC_U_PrevAndNext(Session session, LaunchSet launchSet, long companyId, long userId, OrderByComparator<LaunchSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
        sb.append("launchSet.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_U_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchSet.modifiedDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchSet)list.get(1);
        }
        return null;
    }

    public void removeByC_U(long companyId, long userId) {
        for (LaunchSet launchSet : this.findByC_U(companyId, userId, -1, -1, null)) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countByC_U(long companyId, long userId) {
        FinderPath finderPath = this._finderPathCountByC_U;
        Object[] finderArgs = new Object[]{companyId, userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_U_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchSet> findByC_S(long companyId, int status) {
        return this.findByC_S(companyId, status, -1, -1, null);
    }

    public List<LaunchSet> findByC_S(long companyId, int status, int start, int end) {
        return this.findByC_S(companyId, status, start, end, null);
    }

    public List<LaunchSet> findByC_S(long companyId, int status, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByC_S(companyId, status, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByC_S(long companyId, int status, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (companyId == launchSet.getCompanyId() && status == launchSet.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchSet findByC_S_First(long companyId, int status, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByC_S_First(companyId, status, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByC_S_First(long companyId, int status, OrderByComparator<LaunchSet> orderByComparator) {
        List<LaunchSet> list = this.findByC_S(companyId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet findByC_S_Last(long companyId, int status, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByC_S_Last(companyId, status, orderByComparator);
        if (launchSet != null) {
            return launchSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchLaunchSetException(sb.toString());
    }

    public LaunchSet fetchByC_S_Last(long companyId, int status, OrderByComparator<LaunchSet> orderByComparator) {
        int count = this.countByC_S(companyId, status);
        if (count == 0) {
            return null;
        }
        List<LaunchSet> list = this.findByC_S(companyId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchSet[] findByC_S_PrevAndNext(long launchSetId, long companyId, int status, OrderByComparator<LaunchSet> orderByComparator) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.findByPrimaryKey(launchSetId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet[] array = new LaunchSetImpl[]{this.getByC_S_PrevAndNext(session, launchSet, companyId, status, orderByComparator, true), launchSet, this.getByC_S_PrevAndNext(session, launchSet, companyId, status, orderByComparator, false)};
            LaunchSet[] launchSetArray = array;
            return launchSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet getByC_S_PrevAndNext(Session session, LaunchSet launchSet, long companyId, int status, OrderByComparator<LaunchSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
        sb.append("launchSet.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchSet.modifiedDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchSet)list.get(1);
        }
        return null;
    }

    public List<LaunchSet> findByC_S(long companyId, int[] statuses) {
        return this.findByC_S(companyId, statuses, -1, -1, null);
    }

    public List<LaunchSet> findByC_S(long companyId, int[] statuses, int start, int end) {
        return this.findByC_S(companyId, statuses, start, end, null);
    }

    public List<LaunchSet> findByC_S(long companyId, int[] statuses, int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findByC_S(companyId, statuses, start, end, orderByComparator, true);
    }

    public List<LaunchSet> findByC_S(long companyId, int[] statuses, int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        if (statuses == null) {
            statuses = new int[]{};
        } else if (statuses.length > 1) {
            statuses = ArrayUtil.sortedUnique((int[])statuses);
        }
        if (statuses.length == 1) {
            return this.findByC_S(companyId, statuses[0], start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{companyId, StringUtil.merge((int[])statuses)};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{companyId, StringUtil.merge((int[])statuses), start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByC_S, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchSet launchSet : list) {
                if (companyId == launchSet.getCompanyId() && ArrayUtil.contains((int[])statuses, (int)launchSet.getStatus())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            if (statuses.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_C_S_STATUS_7);
                sb.append(StringUtil.merge((int[])statuses));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(LaunchSetPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchSet.modifiedDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByC_S, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByC_S(long companyId, int status) {
        for (LaunchSet launchSet : this.findByC_S(companyId, status, -1, -1, null)) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countByC_S(long companyId, int status) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByC_S(long companyId, int[] statuses) {
        if (statuses == null) {
            statuses = new int[]{};
        } else if (statuses.length > 1) {
            statuses = ArrayUtil.sortedUnique((int[])statuses);
        }
        Object[] finderArgs = new Object[]{companyId, StringUtil.merge((int[])statuses)};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByC_S, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_LAUNCHSET_WHERE);
            sb.append("launchSet.companyId = ? AND ");
            if (statuses.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_C_S_STATUS_7);
                sb.append(StringUtil.merge((int[])statuses));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(LaunchSetPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByC_S, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LaunchSet findByERC_C(String externalReferenceCode, long companyId) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.fetchByERC_C(externalReferenceCode, companyId);
        if (launchSet == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLaunchSetException(sb.toString());
        }
        return launchSet;
    }

    public LaunchSet fetchByERC_C(String externalReferenceCode, long companyId) {
        return this.fetchByERC_C(externalReferenceCode, companyId, true);
    }

    public LaunchSet fetchByERC_C(String externalReferenceCode, long companyId, boolean useFinderCache) {
        LaunchSet launchSet;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof LaunchSet && (!Objects.equals(externalReferenceCode, (launchSet = (LaunchSet)result).getExternalReferenceCode()) || companyId != launchSet.getCompanyId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHSET_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2);
            }
            sb.append("launchSet.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_C, finderArgs, (Object)list);
                    }
                } else {
                    LaunchSet launchSet2 = (LaunchSet)list.get(0);
                    result = launchSet2;
                    this.cacheResult(launchSet2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LaunchSet)result;
    }

    public LaunchSet removeByERC_C(String externalReferenceCode, long companyId) throws NoSuchLaunchSetException {
        LaunchSet launchSet = this.findByERC_C(externalReferenceCode, companyId);
        return (LaunchSet)this.remove((BaseModel)launchSet);
    }

    public int countByERC_C(String externalReferenceCode, long companyId) {
        LaunchSet launchSet = this.fetchByERC_C(externalReferenceCode, companyId);
        if (launchSet == null) {
            return 0;
        }
        return 1;
    }

    public LaunchSetPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(LaunchSet.class);
        this.setModelImplClass(LaunchSetImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)LaunchSetTable.INSTANCE);
    }

    public void cacheResult(LaunchSet launchSet) {
        this.entityCache.putResult(LaunchSetImpl.class, (Serializable)Long.valueOf(launchSet.getPrimaryKey()), (Serializable)launchSet);
        this.finderCache.putResult(this._finderPathFetchByERC_C, new Object[]{launchSet.getExternalReferenceCode(), launchSet.getCompanyId()}, (Object)launchSet);
    }

    public void cacheResult(List<LaunchSet> launchSets) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && launchSets.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (LaunchSet launchSet : launchSets) {
            if (this.entityCache.getResult(LaunchSetImpl.class, (Serializable)Long.valueOf(launchSet.getPrimaryKey())) != null) continue;
            this.cacheResult(launchSet);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(LaunchSetImpl.class);
        this.finderCache.clearCache(LaunchSetImpl.class);
    }

    public void clearCache(LaunchSet launchSet) {
        this.entityCache.removeResult(LaunchSetImpl.class, (BaseModel)launchSet);
    }

    public void clearCache(List<LaunchSet> launchSets) {
        for (LaunchSet launchSet : launchSets) {
            this.entityCache.removeResult(LaunchSetImpl.class, (BaseModel)launchSet);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(LaunchSetImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(LaunchSetImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LaunchSetModelImpl launchSetModelImpl) {
        Object[] args = new Object[]{launchSetModelImpl.getExternalReferenceCode(), launchSetModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathFetchByERC_C, args, (Object)launchSetModelImpl);
    }

    public LaunchSet create(long launchSetId) {
        LaunchSetImpl launchSet = new LaunchSetImpl();
        launchSet.setNew(true);
        launchSet.setPrimaryKey(launchSetId);
        String uuid = PortalUUIDUtil.generate();
        launchSet.setUuid(uuid);
        launchSet.setCompanyId(CompanyThreadLocal.getCompanyId());
        return launchSet;
    }

    public LaunchSet remove(long launchSetId) throws NoSuchLaunchSetException {
        return this.remove(Long.valueOf(launchSetId));
    }

    public LaunchSet remove(Serializable primaryKey) throws NoSuchLaunchSetException {
        Session session = null;
        try {
            session = this.openSession();
            LaunchSet launchSet = (LaunchSet)session.get(LaunchSetImpl.class, primaryKey);
            if (launchSet == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchLaunchSetException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            LaunchSet launchSet2 = (LaunchSet)this.remove((BaseModel)launchSet);
            return launchSet2;
        }
        catch (NoSuchLaunchSetException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchSet removeImpl(LaunchSet launchSet) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)launchSet)) {
                launchSet = (LaunchSet)session.get(LaunchSetImpl.class, launchSet.getPrimaryKeyObj());
            }
            if (launchSet != null) {
                session.delete((Object)launchSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (launchSet != null) {
            this.clearCache(launchSet);
        }
        return launchSet;
    }

    public LaunchSet updateImpl(LaunchSet launchSet) {
        boolean isNew = launchSet.isNew();
        if (!(launchSet instanceof LaunchSetModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)launchSet.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)launchSet);
                throw new IllegalArgumentException("Implement ModelWrapper in launchSet proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom LaunchSet implementation " + String.valueOf(launchSet.getClass()));
        }
        LaunchSetModelImpl launchSetModelImpl = (LaunchSetModelImpl)launchSet;
        if (Validator.isNull((String)launchSet.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            launchSet.setUuid(uuid);
        }
        if (Validator.isNull((String)launchSet.getExternalReferenceCode())) {
            launchSet.setExternalReferenceCode(launchSet.getUuid());
        } else {
            long userId;
            if (!Objects.equals(launchSetModelImpl.getColumnOriginalValue("externalReferenceCode"), launchSet.getExternalReferenceCode()) && (userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
                long companyId = launchSet.getCompanyId();
                long groupId = 0L;
                long classPK = 0L;
                if (!isNew) {
                    classPK = launchSet.getPrimaryKey();
                }
                try {
                    launchSet.setExternalReferenceCode(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)LaunchSet.class.getName(), (long)classPK, (String)"text/html", (String)"ALL", (String)launchSet.getExternalReferenceCode(), null));
                }
                catch (SanitizerException sanitizerException) {
                    throw new SystemException((Throwable)sanitizerException);
                }
            }
            LaunchSet ercLaunchSet = this.fetchByERC_C(launchSet.getExternalReferenceCode(), launchSet.getCompanyId());
            if (isNew ? ercLaunchSet != null : ercLaunchSet != null && launchSet.getLaunchSetId() != ercLaunchSet.getLaunchSetId()) {
                throw new DuplicateLaunchSetExternalReferenceCodeException("Duplicate launch set with external reference code " + launchSet.getExternalReferenceCode() + " and company " + launchSet.getCompanyId());
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && launchSet.getCreateDate() == null) {
            if (serviceContext == null) {
                launchSet.setCreateDate(date);
            } else {
                launchSet.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!launchSetModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                launchSet.setModifiedDate(date);
            } else {
                launchSet.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)launchSet);
            } else {
                launchSet = (LaunchSet)session.merge((Object)launchSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(LaunchSetImpl.class, (BaseModel)launchSetModelImpl, false, true);
        this.cacheUniqueFindersCache(launchSetModelImpl);
        if (isNew) {
            launchSet.setNew(false);
        }
        launchSet.resetOriginalValues();
        return launchSet;
    }

    public LaunchSet findByPrimaryKey(Serializable primaryKey) throws NoSuchLaunchSetException {
        LaunchSet launchSet = (LaunchSet)this.fetchByPrimaryKey(primaryKey);
        if (launchSet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchLaunchSetException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return launchSet;
    }

    public LaunchSet findByPrimaryKey(long launchSetId) throws NoSuchLaunchSetException {
        return this.findByPrimaryKey(Long.valueOf(launchSetId));
    }

    public LaunchSet fetchByPrimaryKey(long launchSetId) {
        return (LaunchSet)this.fetchByPrimaryKey(Long.valueOf(launchSetId));
    }

    public List<LaunchSet> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<LaunchSet> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<LaunchSet> findAll(int start, int end, OrderByComparator<LaunchSet> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<LaunchSet> findAll(int start, int end, OrderByComparator<LaunchSet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_LAUNCHSET);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_LAUNCHSET;
                sql = sql.concat(" ORDER BY launchSet.modifiedDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (LaunchSet launchSet : this.findAll()) {
            this.remove((BaseModel)launchSet);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_LAUNCHSET);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "launchSetId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LAUNCHSET;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return LaunchSetModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_U = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_U", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "userId"}, true);
        this._finderPathWithoutPaginationFindByC_U = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_U", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "userId"}, true);
        this._finderPathCountByC_U = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_U", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "userId"}, false);
        this._finderPathWithPaginationFindByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "status"}, true);
        this._finderPathWithoutPaginationFindByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "status"}, true);
        this._finderPathCountByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "status"}, false);
        this._finderPathWithPaginationCountByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "status"}, false);
        this._finderPathFetchByERC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId"}, true);
        LaunchSetUtil.setPersistence((LaunchSetPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        LaunchSetUtil.setPersistence(null);
        this.entityCache.removeCache(LaunchSetImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.launch.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.launch.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.launch.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

