/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.launch.service.persistence.impl;

import com.liferay.launch.exception.DuplicateLaunchEntryExternalReferenceCodeException;
import com.liferay.launch.exception.NoSuchLaunchEntryException;
import com.liferay.launch.model.LaunchEntry;
import com.liferay.launch.model.LaunchEntryTable;
import com.liferay.launch.model.impl.LaunchEntryImpl;
import com.liferay.launch.model.impl.LaunchEntryModelImpl;
import com.liferay.launch.service.persistence.LaunchEntryPersistence;
import com.liferay.launch.service.persistence.LaunchEntryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LaunchEntryPersistence.class})
public class LaunchEntryPersistenceImpl
extends BasePersistenceImpl<LaunchEntry>
implements LaunchEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LaunchEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "launchEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(launchEntry.uuid IS NULL OR launchEntry.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "launchEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(launchEntry.uuid IS NULL OR launchEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "launchEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByLaunchSetId;
    private FinderPath _finderPathWithoutPaginationFindByLaunchSetId;
    private FinderPath _finderPathCountByLaunchSetId;
    private static final String _FINDER_COLUMN_LAUNCHSETID_LAUNCHSETID_2 = "launchEntry.launchSetId = ?";
    private FinderPath _finderPathFetchByC_C_C;
    private static final String _FINDER_COLUMN_C_C_C_CLASSNAMEID_2 = "launchEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSPK_2 = "launchEntry.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSVERSION_2 = "launchEntry.classVersion = ?";
    private static final String _FINDER_COLUMN_C_C_C_CLASSVERSION_3 = "(launchEntry.classVersion IS NULL OR launchEntry.classVersion = '')";
    private FinderPath _finderPathFetchByERC_C;
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2 = "launchEntry.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3 = "(launchEntry.externalReferenceCode IS NULL OR launchEntry.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_C_COMPANYID_2 = "launchEntry.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_LAUNCHENTRY = "SELECT launchEntry FROM LaunchEntry launchEntry";
    private static final String _SQL_SELECT_LAUNCHENTRY_WHERE = "SELECT launchEntry FROM LaunchEntry launchEntry WHERE ";
    private static final String _SQL_COUNT_LAUNCHENTRY = "SELECT COUNT(launchEntry) FROM LaunchEntry launchEntry";
    private static final String _SQL_COUNT_LAUNCHENTRY_WHERE = "SELECT COUNT(launchEntry) FROM LaunchEntry launchEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "launchEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LaunchEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LaunchEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(LaunchEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<LaunchEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<LaunchEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<LaunchEntry> findByUuid(String uuid, int start, int end, OrderByComparator<LaunchEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<LaunchEntry> findByUuid(String uuid, int start, int end, OrderByComparator<LaunchEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchEntry launchEntry : list) {
                if (uuid.equals(launchEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchEntry.launchEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchEntry findByUuid_First(String uuid, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByUuid_First(String uuid, OrderByComparator<LaunchEntry> orderByComparator) {
        List<LaunchEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry findByUuid_Last(String uuid, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByUuid_Last(String uuid, OrderByComparator<LaunchEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<LaunchEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry[] findByUuid_PrevAndNext(long launchEntryId, String uuid, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        uuid = Objects.toString(uuid, "");
        LaunchEntry launchEntry = this.findByPrimaryKey(launchEntryId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchEntry[] array = new LaunchEntryImpl[]{this.getByUuid_PrevAndNext(session, launchEntry, uuid, orderByComparator, true), launchEntry, this.getByUuid_PrevAndNext(session, launchEntry, uuid, orderByComparator, false)};
            LaunchEntry[] launchEntryArray = array;
            return launchEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchEntry getByUuid_PrevAndNext(Session session, LaunchEntry launchEntry, String uuid, OrderByComparator<LaunchEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchEntry.launchEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (LaunchEntry launchEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)launchEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAUNCHENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<LaunchEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<LaunchEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LaunchEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<LaunchEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LaunchEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchEntry launchEntry : list) {
                if (uuid.equals(launchEntry.getUuid()) && companyId == launchEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("launchEntry.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchEntry.launchEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator) {
        List<LaunchEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<LaunchEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry[] findByUuid_C_PrevAndNext(long launchEntryId, String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        uuid = Objects.toString(uuid, "");
        LaunchEntry launchEntry = this.findByPrimaryKey(launchEntryId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchEntry[] array = new LaunchEntryImpl[]{this.getByUuid_C_PrevAndNext(session, launchEntry, uuid, companyId, orderByComparator, true), launchEntry, this.getByUuid_C_PrevAndNext(session, launchEntry, uuid, companyId, orderByComparator, false)};
            LaunchEntry[] launchEntryArray = array;
            return launchEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchEntry getByUuid_C_PrevAndNext(Session session, LaunchEntry launchEntry, String uuid, long companyId, OrderByComparator<LaunchEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("launchEntry.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchEntry.launchEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (LaunchEntry launchEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)launchEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAUNCHENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("launchEntry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LaunchEntry> findByLaunchSetId(long launchSetId) {
        return this.findByLaunchSetId(launchSetId, -1, -1, null);
    }

    public List<LaunchEntry> findByLaunchSetId(long launchSetId, int start, int end) {
        return this.findByLaunchSetId(launchSetId, start, end, null);
    }

    public List<LaunchEntry> findByLaunchSetId(long launchSetId, int start, int end, OrderByComparator<LaunchEntry> orderByComparator) {
        return this.findByLaunchSetId(launchSetId, start, end, orderByComparator, true);
    }

    public List<LaunchEntry> findByLaunchSetId(long launchSetId, int start, int end, OrderByComparator<LaunchEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByLaunchSetId;
                finderArgs = new Object[]{launchSetId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByLaunchSetId;
            finderArgs = new Object[]{launchSetId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (LaunchEntry launchEntry : list) {
                if (launchSetId == launchEntry.getLaunchSetId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_LAUNCHSETID_LAUNCHSETID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY launchEntry.launchEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(launchSetId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LaunchEntry findByLaunchSetId_First(long launchSetId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByLaunchSetId_First(launchSetId, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("launchSetId=");
        sb.append(launchSetId);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByLaunchSetId_First(long launchSetId, OrderByComparator<LaunchEntry> orderByComparator) {
        List<LaunchEntry> list = this.findByLaunchSetId(launchSetId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry findByLaunchSetId_Last(long launchSetId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByLaunchSetId_Last(launchSetId, orderByComparator);
        if (launchEntry != null) {
            return launchEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("launchSetId=");
        sb.append(launchSetId);
        sb.append("}");
        throw new NoSuchLaunchEntryException(sb.toString());
    }

    public LaunchEntry fetchByLaunchSetId_Last(long launchSetId, OrderByComparator<LaunchEntry> orderByComparator) {
        int count = this.countByLaunchSetId(launchSetId);
        if (count == 0) {
            return null;
        }
        List<LaunchEntry> list = this.findByLaunchSetId(launchSetId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LaunchEntry[] findByLaunchSetId_PrevAndNext(long launchEntryId, long launchSetId, OrderByComparator<LaunchEntry> orderByComparator) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.findByPrimaryKey(launchEntryId);
        Session session = null;
        try {
            session = this.openSession();
            LaunchEntry[] array = new LaunchEntryImpl[]{this.getByLaunchSetId_PrevAndNext(session, launchEntry, launchSetId, orderByComparator, true), launchEntry, this.getByLaunchSetId_PrevAndNext(session, launchEntry, launchSetId, orderByComparator, false)};
            LaunchEntry[] launchEntryArray = array;
            return launchEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchEntry getByLaunchSetId_PrevAndNext(Session session, LaunchEntry launchEntry, long launchSetId, OrderByComparator<LaunchEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
        sb.append(_FINDER_COLUMN_LAUNCHSETID_LAUNCHSETID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY launchEntry.launchEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(launchSetId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)launchEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LaunchEntry)list.get(1);
        }
        return null;
    }

    public void removeByLaunchSetId(long launchSetId) {
        for (LaunchEntry launchEntry : this.findByLaunchSetId(launchSetId, -1, -1, null)) {
            this.remove((BaseModel)launchEntry);
        }
    }

    public int countByLaunchSetId(long launchSetId) {
        FinderPath finderPath = this._finderPathCountByLaunchSetId;
        Object[] finderArgs = new Object[]{launchSetId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAUNCHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_LAUNCHSETID_LAUNCHSETID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(launchSetId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LaunchEntry findByC_C_C(long classNameId, long classPK, String classVersion) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByC_C_C(classNameId, classPK, classVersion);
        if (launchEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append(", classVersion=");
            sb.append(classVersion);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLaunchEntryException(sb.toString());
        }
        return launchEntry;
    }

    public LaunchEntry fetchByC_C_C(long classNameId, long classPK, String classVersion) {
        return this.fetchByC_C_C(classNameId, classPK, classVersion, true);
    }

    public LaunchEntry fetchByC_C_C(long classNameId, long classPK, String classVersion, boolean useFinderCache) {
        LaunchEntry launchEntry;
        classVersion = Objects.toString(classVersion, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{classNameId, classPK, classVersion};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof LaunchEntry && (classNameId != (launchEntry = (LaunchEntry)result).getClassNameId() || classPK != launchEntry.getClassPK() || !Objects.equals(classVersion, launchEntry.getClassVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_C_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
            boolean bindClassVersion = false;
            if (classVersion.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_C_CLASSVERSION_3);
            } else {
                bindClassVersion = true;
                sb.append(_FINDER_COLUMN_C_C_C_CLASSVERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                if (bindClassVersion) {
                    queryPos.add(classVersion);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C_C, finderArgs, (Object)list);
                    }
                } else {
                    LaunchEntry launchEntry2 = (LaunchEntry)list.get(0);
                    result = launchEntry2;
                    this.cacheResult(launchEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LaunchEntry)result;
    }

    public LaunchEntry removeByC_C_C(long classNameId, long classPK, String classVersion) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.findByC_C_C(classNameId, classPK, classVersion);
        return (LaunchEntry)this.remove((BaseModel)launchEntry);
    }

    public int countByC_C_C(long classNameId, long classPK, String classVersion) {
        LaunchEntry launchEntry = this.fetchByC_C_C(classNameId, classPK, classVersion);
        if (launchEntry == null) {
            return 0;
        }
        return 1;
    }

    public LaunchEntry findByERC_C(String externalReferenceCode, long companyId) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.fetchByERC_C(externalReferenceCode, companyId);
        if (launchEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLaunchEntryException(sb.toString());
        }
        return launchEntry;
    }

    public LaunchEntry fetchByERC_C(String externalReferenceCode, long companyId) {
        return this.fetchByERC_C(externalReferenceCode, companyId, true);
    }

    public LaunchEntry fetchByERC_C(String externalReferenceCode, long companyId, boolean useFinderCache) {
        LaunchEntry launchEntry;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof LaunchEntry && (!Objects.equals(externalReferenceCode, (launchEntry = (LaunchEntry)result).getExternalReferenceCode()) || companyId != launchEntry.getCompanyId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LAUNCHENTRY_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2);
            }
            sb.append("launchEntry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_C, finderArgs, (Object)list);
                    }
                } else {
                    LaunchEntry launchEntry2 = (LaunchEntry)list.get(0);
                    result = launchEntry2;
                    this.cacheResult(launchEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LaunchEntry)result;
    }

    public LaunchEntry removeByERC_C(String externalReferenceCode, long companyId) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = this.findByERC_C(externalReferenceCode, companyId);
        return (LaunchEntry)this.remove((BaseModel)launchEntry);
    }

    public int countByERC_C(String externalReferenceCode, long companyId) {
        LaunchEntry launchEntry = this.fetchByERC_C(externalReferenceCode, companyId);
        if (launchEntry == null) {
            return 0;
        }
        return 1;
    }

    public LaunchEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(LaunchEntry.class);
        this.setModelImplClass(LaunchEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)LaunchEntryTable.INSTANCE);
    }

    public void cacheResult(LaunchEntry launchEntry) {
        this.entityCache.putResult(LaunchEntryImpl.class, (Serializable)Long.valueOf(launchEntry.getPrimaryKey()), (Serializable)launchEntry);
        this.finderCache.putResult(this._finderPathFetchByC_C_C, new Object[]{launchEntry.getClassNameId(), launchEntry.getClassPK(), launchEntry.getClassVersion()}, (Object)launchEntry);
        this.finderCache.putResult(this._finderPathFetchByERC_C, new Object[]{launchEntry.getExternalReferenceCode(), launchEntry.getCompanyId()}, (Object)launchEntry);
    }

    public void cacheResult(List<LaunchEntry> launchEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && launchEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (LaunchEntry launchEntry : launchEntries) {
            if (this.entityCache.getResult(LaunchEntryImpl.class, (Serializable)Long.valueOf(launchEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(launchEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(LaunchEntryImpl.class);
        this.finderCache.clearCache(LaunchEntryImpl.class);
    }

    public void clearCache(LaunchEntry launchEntry) {
        this.entityCache.removeResult(LaunchEntryImpl.class, (BaseModel)launchEntry);
    }

    public void clearCache(List<LaunchEntry> launchEntries) {
        for (LaunchEntry launchEntry : launchEntries) {
            this.entityCache.removeResult(LaunchEntryImpl.class, (BaseModel)launchEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(LaunchEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(LaunchEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LaunchEntryModelImpl launchEntryModelImpl) {
        Object[] args = new Object[]{launchEntryModelImpl.getClassNameId(), launchEntryModelImpl.getClassPK(), launchEntryModelImpl.getClassVersion()};
        this.finderCache.putResult(this._finderPathFetchByC_C_C, args, (Object)launchEntryModelImpl);
        args = new Object[]{launchEntryModelImpl.getExternalReferenceCode(), launchEntryModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathFetchByERC_C, args, (Object)launchEntryModelImpl);
    }

    public LaunchEntry create(long launchEntryId) {
        LaunchEntryImpl launchEntry = new LaunchEntryImpl();
        launchEntry.setNew(true);
        launchEntry.setPrimaryKey(launchEntryId);
        String uuid = PortalUUIDUtil.generate();
        launchEntry.setUuid(uuid);
        launchEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return launchEntry;
    }

    public LaunchEntry remove(long launchEntryId) throws NoSuchLaunchEntryException {
        return this.remove(Long.valueOf(launchEntryId));
    }

    public LaunchEntry remove(Serializable primaryKey) throws NoSuchLaunchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            LaunchEntry launchEntry = (LaunchEntry)session.get(LaunchEntryImpl.class, primaryKey);
            if (launchEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchLaunchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            LaunchEntry launchEntry2 = (LaunchEntry)this.remove((BaseModel)launchEntry);
            return launchEntry2;
        }
        catch (NoSuchLaunchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LaunchEntry removeImpl(LaunchEntry launchEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)launchEntry)) {
                launchEntry = (LaunchEntry)session.get(LaunchEntryImpl.class, launchEntry.getPrimaryKeyObj());
            }
            if (launchEntry != null) {
                session.delete((Object)launchEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (launchEntry != null) {
            this.clearCache(launchEntry);
        }
        return launchEntry;
    }

    public LaunchEntry updateImpl(LaunchEntry launchEntry) {
        boolean isNew = launchEntry.isNew();
        if (!(launchEntry instanceof LaunchEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)launchEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)launchEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in launchEntry proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom LaunchEntry implementation " + String.valueOf(launchEntry.getClass()));
        }
        LaunchEntryModelImpl launchEntryModelImpl = (LaunchEntryModelImpl)launchEntry;
        if (Validator.isNull((String)launchEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            launchEntry.setUuid(uuid);
        }
        if (Validator.isNull((String)launchEntry.getExternalReferenceCode())) {
            launchEntry.setExternalReferenceCode(launchEntry.getUuid());
        } else {
            long userId;
            if (!Objects.equals(launchEntryModelImpl.getColumnOriginalValue("externalReferenceCode"), launchEntry.getExternalReferenceCode()) && (userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
                long companyId = launchEntry.getCompanyId();
                long groupId = 0L;
                long classPK = 0L;
                if (!isNew) {
                    classPK = launchEntry.getPrimaryKey();
                }
                try {
                    launchEntry.setExternalReferenceCode(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)LaunchEntry.class.getName(), (long)classPK, (String)"text/html", (String)"ALL", (String)launchEntry.getExternalReferenceCode(), null));
                }
                catch (SanitizerException sanitizerException) {
                    throw new SystemException((Throwable)sanitizerException);
                }
            }
            LaunchEntry ercLaunchEntry = this.fetchByERC_C(launchEntry.getExternalReferenceCode(), launchEntry.getCompanyId());
            if (isNew ? ercLaunchEntry != null : ercLaunchEntry != null && launchEntry.getLaunchEntryId() != ercLaunchEntry.getLaunchEntryId()) {
                throw new DuplicateLaunchEntryExternalReferenceCodeException("Duplicate launch entry with external reference code " + launchEntry.getExternalReferenceCode() + " and company " + launchEntry.getCompanyId());
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && launchEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                launchEntry.setCreateDate(date);
            } else {
                launchEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!launchEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                launchEntry.setModifiedDate(date);
            } else {
                launchEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)launchEntry);
            } else {
                launchEntry = (LaunchEntry)session.merge((Object)launchEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(LaunchEntryImpl.class, (BaseModel)launchEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(launchEntryModelImpl);
        if (isNew) {
            launchEntry.setNew(false);
        }
        launchEntry.resetOriginalValues();
        return launchEntry;
    }

    public LaunchEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchLaunchEntryException {
        LaunchEntry launchEntry = (LaunchEntry)this.fetchByPrimaryKey(primaryKey);
        if (launchEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchLaunchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return launchEntry;
    }

    public LaunchEntry findByPrimaryKey(long launchEntryId) throws NoSuchLaunchEntryException {
        return this.findByPrimaryKey(Long.valueOf(launchEntryId));
    }

    public LaunchEntry fetchByPrimaryKey(long launchEntryId) {
        return (LaunchEntry)this.fetchByPrimaryKey(Long.valueOf(launchEntryId));
    }

    public List<LaunchEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<LaunchEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<LaunchEntry> findAll(int start, int end, OrderByComparator<LaunchEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<LaunchEntry> findAll(int start, int end, OrderByComparator<LaunchEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_LAUNCHENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_LAUNCHENTRY;
                sql = sql.concat(" ORDER BY launchEntry.launchEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (LaunchEntry launchEntry : this.findAll()) {
            this.remove((BaseModel)launchEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_LAUNCHENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "launchEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LAUNCHENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return LaunchEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByLaunchSetId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLaunchSetId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"launchSetId"}, true);
        this._finderPathWithoutPaginationFindByLaunchSetId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLaunchSetId", new String[]{Long.class.getName()}, new String[]{"launchSetId"}, true);
        this._finderPathCountByLaunchSetId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLaunchSetId", new String[]{Long.class.getName()}, new String[]{"launchSetId"}, false);
        this._finderPathFetchByC_C_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"classNameId", "classPK", "classVersion"}, true);
        this._finderPathFetchByERC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId"}, true);
        LaunchEntryUtil.setPersistence((LaunchEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        LaunchEntryUtil.setPersistence(null);
        this.entityCache.removeCache(LaunchEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.launch.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.launch.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.launch.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

