/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.launch.model.impl;

import com.liferay.launch.model.LaunchEntry;
import com.liferay.launch.service.LaunchEntryLocalServiceUtil;

/**
 * The extended model base implementation for the LaunchEntry service. Represents a row in the &quot;LaunchEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LaunchEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LaunchEntryImpl
 * @see LaunchEntry
 * @generated
 */
public abstract class LaunchEntryBaseImpl
	extends LaunchEntryModelImpl implements LaunchEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a launch entry model instance should use the <code>LaunchEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LaunchEntryLocalServiceUtil.addLaunchEntry(this);
		}
		else {
			LaunchEntryLocalServiceUtil.updateLaunchEntry(this);
		}
	}

}