/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.launch.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LaunchEntry service. Represents a row in the &quot;LaunchEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.launch.model.impl.LaunchEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.launch.model.impl.LaunchEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LaunchEntry
 * @generated
 */
@ProviderType
public interface LaunchEntryModel
	extends AttachedModel, BaseModel<LaunchEntry>, ExternalReferenceCodeModel,
			MVCCModel, ShardedModel, StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a launch entry model instance should use the {@link LaunchEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this launch entry.
	 *
	 * @return the primary key of this launch entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this launch entry.
	 *
	 * @param primaryKey the primary key of this launch entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this launch entry.
	 *
	 * @return the mvcc version of this launch entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this launch entry.
	 *
	 * @param mvccVersion the mvcc version of this launch entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this launch entry.
	 *
	 * @return the uuid of this launch entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this launch entry.
	 *
	 * @param uuid the uuid of this launch entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this launch entry.
	 *
	 * @return the external reference code of this launch entry
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this launch entry.
	 *
	 * @param externalReferenceCode the external reference code of this launch entry
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the launch entry ID of this launch entry.
	 *
	 * @return the launch entry ID of this launch entry
	 */
	public long getLaunchEntryId();

	/**
	 * Sets the launch entry ID of this launch entry.
	 *
	 * @param launchEntryId the launch entry ID of this launch entry
	 */
	public void setLaunchEntryId(long launchEntryId);

	/**
	 * Returns the company ID of this launch entry.
	 *
	 * @return the company ID of this launch entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this launch entry.
	 *
	 * @param companyId the company ID of this launch entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this launch entry.
	 *
	 * @return the user ID of this launch entry
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this launch entry.
	 *
	 * @param userId the user ID of this launch entry
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this launch entry.
	 *
	 * @return the user uuid of this launch entry
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this launch entry.
	 *
	 * @param userUuid the user uuid of this launch entry
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this launch entry.
	 *
	 * @return the create date of this launch entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this launch entry.
	 *
	 * @param createDate the create date of this launch entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this launch entry.
	 *
	 * @return the modified date of this launch entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this launch entry.
	 *
	 * @param modifiedDate the modified date of this launch entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the launch set ID of this launch entry.
	 *
	 * @return the launch set ID of this launch entry
	 */
	public long getLaunchSetId();

	/**
	 * Sets the launch set ID of this launch entry.
	 *
	 * @param launchSetId the launch set ID of this launch entry
	 */
	public void setLaunchSetId(long launchSetId);

	/**
	 * Returns the fully qualified class name of this launch entry.
	 *
	 * @return the fully qualified class name of this launch entry
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this launch entry.
	 *
	 * @return the class name ID of this launch entry
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this launch entry.
	 *
	 * @param classNameId the class name ID of this launch entry
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this launch entry.
	 *
	 * @return the class pk of this launch entry
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this launch entry.
	 *
	 * @param classPK the class pk of this launch entry
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the class version of this launch entry.
	 *
	 * @return the class version of this launch entry
	 */
	@AutoEscape
	public String getClassVersion();

	/**
	 * Sets the class version of this launch entry.
	 *
	 * @param classVersion the class version of this launch entry
	 */
	public void setClassVersion(String classVersion);

	@Override
	public LaunchEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}