/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.display;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the KBArticle UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link KBArticleUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBArticleUADDisplay
	extends BaseModelUADDisplay<KBArticle> {

	@Override
	public KBArticle get(Serializable primaryKey) throws PortalException {
		return kbArticleLocalService.getKBArticle(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"title", "urlTitle", "content", "description"};
	}

	@Override
	public Class<KBArticle> getTypeClass() {
		return KBArticle.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return kbArticleLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return kbArticleLocalService.dynamicQuery();
	}

	@Override
	protected List<KBArticle> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return kbArticleLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_ARTICLE;
	}

	@Reference
	protected KBArticleLocalService kbArticleLocalService;

}