/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.object.internal.odata.entity.v1_0.ObjectEntryFolderEntityModel;
import com.liferay.headless.object.internal.resource.v1_0.BaseObjectEntryFolderResourceImpl;
import com.liferay.headless.object.resource.v1_0.ObjectEntryFolderResource;
import com.liferay.object.exception.NoSuchObjectEntryFolderException;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderService;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/object-entry-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={ObjectEntryFolderResource.class})
public class ObjectEntryFolderResourceImpl
extends BaseObjectEntryFolderResourceImpl {
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(component.name=com.liferay.headless.object.internal.dto.v1_0.converter.ObjectEntryFolderDTOConverter)")
    private DTOConverter<ObjectEntryFolder, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder> _objectEntryFolderDTOConverter;
    @Reference
    private ObjectEntryFolderService _objectEntryFolderService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteObjectEntryFolder(Long objectEntryFolderId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._objectEntryFolderService.deleteObjectEntryFolder(objectEntryFolderId.longValue());
    }

    @Override
    public void deleteScopeScopeKeyObjectEntryFolderByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._objectEntryFolderService.deleteObjectEntryFolderByExternalReferenceCode(externalReferenceCode, this._getGroupId(scopeKey), this.contextCompany.getCompanyId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new ObjectEntryFolderEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(ObjectEntryFolder.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder getObjectEntryFolder(Long objectEntryFolderId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toObjectEntryFolder(this._objectEntryFolderService.getObjectEntryFolder(objectEntryFolderId.longValue()));
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder getScopeScopeKeyObjectEntryFolderByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toObjectEntryFolder(this._objectEntryFolderService.getObjectEntryFolderByExternalReferenceCode(externalReferenceCode, this._getGroupId(scopeKey), this.contextCompany.getCompanyId()));
    }

    @Override
    public Page<com.liferay.headless.object.dto.v1_0.ObjectEntryFolder> getScopeScopeKeyObjectEntryFoldersPage(String scopeKey, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        long groupId = this._getGroupId(scopeKey);
        DepotEntry depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(groupId);
        if (depotEntry == null) {
            throw new NoSuchObjectEntryFolderException();
        }
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_FOLDER", "postScopeScopeKeyObjectEntryFolder", ObjectEntryFolder.class.getName(), groupId)).put((Object)"get", this.addAction("VIEW", "getScopeScopeKeyObjectEntryFoldersPage", ObjectEntryFolder.class.getName(), groupId)).build(), booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("groupId", scopeKey), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, (String)ObjectEntryFolder.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
        }, (Sort[])sorts, document -> this._toObjectEntryFolder(this._objectEntryFolderService.getObjectEntryFolder(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder patchObjectEntryFolder(Long objectEntryFolderId, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._patchObjectEntryFolder(objectEntryFolder, this._objectEntryFolderService.getObjectEntryFolder(objectEntryFolderId.longValue()));
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder patchScopeScopeKeyObjectEntryFolderByExternalReferenceCode(String scopeKey, String externalReferenceCode, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._patchObjectEntryFolder(objectEntryFolder, this._objectEntryFolderService.getObjectEntryFolderByExternalReferenceCode(externalReferenceCode, this._getGroupId(scopeKey), this.contextCompany.getCompanyId()));
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder postScopeScopeKeyObjectEntryFolder(String scopeKey, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        long groupId = this._getGroupId(scopeKey);
        return this._addObjectEntryFolder(groupId, GetterUtil.getLong((Object)this._getParentObjectEntryFolderId(false, groupId, objectEntryFolder)), objectEntryFolder);
    }

    @Override
    public com.liferay.headless.object.dto.v1_0.ObjectEntryFolder putScopeScopeKeyObjectEntryFolderByExternalReferenceCode(String scopeKey, String externalReferenceCode, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        long groupId = this._getGroupId(scopeKey);
        ObjectEntryFolder persistedObjectEntryFolder = this._objectEntryFolderService.fetchObjectEntryFolderByExternalReferenceCode(externalReferenceCode, groupId, this.contextUser.getCompanyId());
        if (persistedObjectEntryFolder == null) {
            return this._addObjectEntryFolder(groupId, GetterUtil.getLong((Object)this._getParentObjectEntryFolderId(true, groupId, objectEntryFolder)), objectEntryFolder);
        }
        return this._toObjectEntryFolder(this._objectEntryFolderService.updateObjectEntryFolder(persistedObjectEntryFolder.getObjectEntryFolderId(), GetterUtil.getLong((Object)this._getParentObjectEntryFolderId(true, groupId, objectEntryFolder)), objectEntryFolder.getDescription(), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)objectEntryFolder.getLabel(), (Map)objectEntryFolder.getLabel_i18n()), objectEntryFolder.getTitle(), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build()));
    }

    private com.liferay.headless.object.dto.v1_0.ObjectEntryFolder _addObjectEntryFolder(long groupId, long parentObjectEntryFolderId, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        return this._toObjectEntryFolder(this._objectEntryFolderService.addObjectEntryFolder(objectEntryFolder.getExternalReferenceCode(), groupId, parentObjectEntryFolderId, objectEntryFolder.getDescription(), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)objectEntryFolder.getLabel(), (Map)objectEntryFolder.getLabel_i18n()), objectEntryFolder.getTitle(), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)objectEntryFolder.getViewableByAsString()).build()));
    }

    private long _getGroupId(String scopeKey) throws Exception {
        Long groupId = GroupUtil.getGroupId((long)this.contextCompany.getCompanyId(), (String)scopeKey, (GroupLocalService)this._groupLocalService);
        if (groupId != null) {
            return groupId;
        }
        if (Objects.equals(scopeKey, "0")) {
            return 0L;
        }
        throw new NoSuchGroupException();
    }

    private Long _getParentObjectEntryFolderId(boolean addObjectEntryFolder, long groupId, com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder) throws Exception {
        String parentObjectEntryFolderExternalReferenceCode = objectEntryFolder.getParentObjectEntryFolderExternalReferenceCode();
        Long parentObjectEntryFolderId = objectEntryFolder.getParentObjectEntryFolderId();
        if (Validator.isNull((String)parentObjectEntryFolderExternalReferenceCode)) {
            if (parentObjectEntryFolderId == null) {
                return null;
            }
            if (parentObjectEntryFolderId != 0L) {
                this._objectEntryFolderService.getObjectEntryFolder(parentObjectEntryFolderId.longValue());
            }
            return parentObjectEntryFolderId;
        }
        ObjectEntryFolder persistedObjectEntryFolder = this._objectEntryFolderService.fetchObjectEntryFolderByExternalReferenceCode(parentObjectEntryFolderExternalReferenceCode, groupId, this.contextUser.getCompanyId());
        if (parentObjectEntryFolderId != null && (persistedObjectEntryFolder == null || persistedObjectEntryFolder.getObjectEntryFolderId() != parentObjectEntryFolderId.longValue())) {
            throw new NoSuchObjectEntryFolderException();
        }
        if (persistedObjectEntryFolder == null) {
            if (!addObjectEntryFolder) {
                throw new NoSuchObjectEntryFolderException();
            }
            persistedObjectEntryFolder = this._objectEntryFolderService.addObjectEntryFolder(parentObjectEntryFolderExternalReferenceCode, groupId, 0L, null, null, parentObjectEntryFolderExternalReferenceCode, ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build());
        }
        return persistedObjectEntryFolder.getObjectEntryFolderId();
    }

    private com.liferay.headless.object.dto.v1_0.ObjectEntryFolder _patchObjectEntryFolder(com.liferay.headless.object.dto.v1_0.ObjectEntryFolder objectEntryFolder, ObjectEntryFolder persistedObjectEntryFolder) throws Exception {
        Long parentObjectEntryFolderId;
        Map labelMap;
        String description = objectEntryFolder.getDescription();
        if (description == null) {
            description = persistedObjectEntryFolder.getDescription();
        }
        if ((labelMap = objectEntryFolder.getLabel_i18n()) == null) {
            labelMap = LocalizedMapUtil.getI18nMap((Map)persistedObjectEntryFolder.getLabelMap());
        }
        if ((parentObjectEntryFolderId = this._getParentObjectEntryFolderId(false, persistedObjectEntryFolder.getGroupId(), objectEntryFolder)) == null) {
            parentObjectEntryFolderId = persistedObjectEntryFolder.getParentObjectEntryFolderId();
        }
        return this._toObjectEntryFolder(this._objectEntryFolderService.updateObjectEntryFolder(persistedObjectEntryFolder.getObjectEntryFolderId(), parentObjectEntryFolderId.longValue(), description, LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)GetterUtil.getString((String)objectEntryFolder.getLabel(), (String)persistedObjectEntryFolder.getLabel()), (Map)labelMap), GetterUtil.getString((String)objectEntryFolder.getTitle(), (String)persistedObjectEntryFolder.getName()), ServiceContextBuilder.create((long)persistedObjectEntryFolder.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build()));
    }

    private com.liferay.headless.object.dto.v1_0.ObjectEntryFolder _toObjectEntryFolder(ObjectEntryFolder persistedObjectEntryFolder) throws Exception {
        return (com.liferay.headless.object.dto.v1_0.ObjectEntryFolder)this._objectEntryFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)persistedObjectEntryFolder, "deleteObjectEntryFolder")).put((Object)"get", this.addAction("VIEW", (GroupedModel)persistedObjectEntryFolder, "getObjectEntryFolder")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)persistedObjectEntryFolder, "patchObjectEntryFolder")).build(), this._dtoConverterRegistry, (Object)persistedObjectEntryFolder.getObjectEntryFolderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

