/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.digital.sales.room.internal.resource.v1_0;

import com.liferay.headless.digital.sales.room.dto.v1_0.DigitalSalesRoom;
import com.liferay.headless.digital.sales.room.dto.v1_0.FileEntry;
import com.liferay.headless.digital.sales.room.internal.resource.v1_0.BaseDigitalSalesRoomResourceImpl;
import com.liferay.headless.digital.sales.room.resource.v1_0.DigitalSalesRoomResource;
import com.liferay.layout.util.LayoutServiceContextHelper;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/digital-sales-room.properties"}, scope=ServiceScope.PROTOTYPE, service={DigitalSalesRoomResource.class})
public class DigitalSalesRoomResourceImpl
extends BaseDigitalSalesRoomResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.digital.sales.room.internal.dto.v1_0.converter.DigitalSalesRoomDTOConverter)")
    private DTOConverter<Group, DigitalSalesRoom> _digitalSalesRoomDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupService _groupService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutServiceContextHelper _layoutServiceContextHelper;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;

    @Override
    public DigitalSalesRoom getDigitalSalesRoom(Long digitalSalesRoomId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66359")) {
            throw new UnsupportedOperationException();
        }
        return this._toDigitalSalesRoom(this._groupService.getGroup(digitalSalesRoomId.longValue()));
    }

    @Override
    public Page<DigitalSalesRoom> getDigitalSalesRoomsPage(String search, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66359")) {
            throw new UnsupportedOperationException();
        }
        long[] classNameIds = new long[]{this._portal.getClassNameId(Group.class.getName())};
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"active", (Object)true).put((Object)"site", (Object)true).build();
        return Page.of(null, this.transform(this._groupService.search(this.contextCompany.getCompanyId(), classNameIds, search, null, params, true, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new GroupNameComparator()), this::_toDigitalSalesRoom), (Pagination)pagination, (long)this._groupService.searchCount(this.contextCompany.getCompanyId(), classNameIds, search, params));
    }

    @Override
    public DigitalSalesRoom postDigitalSalesRoom(DigitalSalesRoom digitalSalesRoom) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66359")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._addGroup(digitalSalesRoom.getExternalReferenceCode(), digitalSalesRoom.getDescription(), digitalSalesRoom.getFriendlyUrlPath(), "com.liferay.digital.sales.room.site.initializer", digitalSalesRoom.getName());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_DSR_ROOM", this.contextCompany.getCompanyId());
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getCompanyId(), objectDefinition.getStorageType());
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, null, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        defaultDTOConverterContext.setAttribute("addActions", (Object)Boolean.FALSE);
        objectEntryManager.addObjectEntry((DTOConverterContext)defaultDTOConverterContext, objectDefinition, this._toObjectEntry(digitalSalesRoom, group), group.getGroupKey());
        StyleBookEntry styleBookEntry = this._styleBookEntryLocalService.fetchStyleBookEntry(group.getGroupId(), "dsr-classic");
        if (styleBookEntry.isHead()) {
            styleBookEntry = this._styleBookEntryLocalService.getDraft(styleBookEntry.getStyleBookEntryId());
        }
        styleBookEntry = this._styleBookEntryLocalService.updateFrontendTokensValues(styleBookEntry.getStyleBookEntryId(), this._getFrontendTokensValues(digitalSalesRoom.getPrimaryColor(), digitalSalesRoom.getSecondaryColor()));
        this._styleBookEntryLocalService.publishDraft(styleBookEntry);
        return this._toDigitalSalesRoom(group);
    }

    private Group _addGroup(String externalReferenceCode, String description, String friendlyURLPath, String siteTemplateKey, String name) throws Exception {
        SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteTemplateKey);
        if (siteInitializer == null) {
            throw new IllegalArgumentException("No site initializer was found for site template key " + siteTemplateKey);
        }
        this._initThemeDisplay();
        try {
            Group group;
            block12: {
                AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(this.contextCompany, this.contextUser);
                try {
                    Group group2 = this._groupService.addGroup(externalReferenceCode, 0L, 0L, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build(), (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)description).build(), 2, null, true, 0, friendlyURLPath, true, false, true, this._getServiceContext());
                    LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)group2.getGroupId(), (long)this.contextUser.getUserId());
                    siteInitializer.initialize(group2.getGroupId());
                    group = group2;
                    if (autoCloseable == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return group;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private String _getFrontendTokensValues(String primaryColor, String secondaryColor) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (!Validator.isBlank((String)primaryColor)) {
            jsonObject = jsonObject.put("brandColor1", JSONUtil.put((String)"cssVariableMapping", (Object)"brand-color-1").put("name", "primaryColor").put("value", primaryColor)).put("btnPrimaryBackgroundColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-primary-background-color").put("name", "primaryColor").put("value", primaryColor)).put("btnPrimaryBorderColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-primary-border-color").put("name", "primaryColor").put("value", primaryColor)).put("btnPrimaryHoverBackgroundColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-primary-hover-background-color").put("name", "primaryColor").put("value", primaryColor)).put("primaryColor", JSONUtil.put((String)"cssVariableMapping", (Object)"primary").put("value", primaryColor));
        }
        if (!Validator.isBlank((String)secondaryColor)) {
            jsonObject = jsonObject.put("brandColor2", JSONUtil.put((String)"cssVariableMapping", (Object)"brand-color-2").put("name", "secondaryColor").put("value", secondaryColor)).put("btnSecondaryBackgroundColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-secondary-background-color").put("name", "secondaryColor").put("value", secondaryColor)).put("btnSecondaryBorderColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-secondary-border-color").put("name", "secondaryColor").put("value", secondaryColor)).put("btnSecondaryHoverBackgroundColor", JSONUtil.put((String)"cssVariableMapping", (Object)"btn-secondary-hover-background-color").put("name", "secondaryColor").put("value", secondaryColor)).put("secondaryColor", JSONUtil.put((String)"cssVariableMapping", (Object)"secondary").put("value", secondaryColor));
        }
        return jsonObject.toString();
    }

    private ServiceContext _getServiceContext() throws PortalException {
        ServiceContext serviceContext = null;
        if (this.contextHttpServletRequest != null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest);
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.contextCompany.getCompanyId());
            serviceContext.setRequest(this.contextHttpServletRequest);
            serviceContext.setUserId(this.contextUser.getUserId());
        }
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        return serviceContext;
    }

    private void _initThemeDisplay() throws Exception {
        if (this.contextHttpServletRequest == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return;
        }
        ServicePreAction servicePreAction = new ServicePreAction();
        servicePreAction.servicePre(this.contextHttpServletRequest, this.contextHttpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, this.contextHttpServletResponse);
        themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setResponse((HttpServletResponse)new DummyHttpServletResponse());
    }

    private DigitalSalesRoom _toDigitalSalesRoom(Group group) throws Exception {
        return (DigitalSalesRoom)this._digitalSalesRoomDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(true, null, this._dtoConverterRegistry, (Object)group.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)group);
    }

    private ObjectEntry _toObjectEntry(final DigitalSalesRoom digitalSalesRoom, final Group group) {
        return new ObjectEntry(){
            {
                this.setProperties(() -> HashMapBuilder.put((Object)"accountId", (Object)digitalSalesRoom.getAccountId()).put((Object)"banner", () -> {
                    FileEntry fileEntry = digitalSalesRoom.getBanner();
                    if (fileEntry == null || Validator.isBlank((String)fileEntry.getFileBase64())) {
                        return null;
                    }
                    return HashMapBuilder.put((Object)"fileBase64", (Object)fileEntry.getFileBase64()).put((Object)"name", (Object)GetterUtil.getString((String)fileEntry.getFileName(), (String)StringUtil.randomString())).build();
                }).put((Object)"channelId", (Object)digitalSalesRoom.getChannelId()).put((Object)"clientLogo", () -> {
                    FileEntry fileEntry = digitalSalesRoom.getClientLogo();
                    if (fileEntry == null || Validator.isBlank((String)fileEntry.getFileBase64())) {
                        return null;
                    }
                    return HashMapBuilder.put((Object)"fileBase64", (Object)fileEntry.getFileBase64()).put((Object)"name", (Object)GetterUtil.getString((String)fileEntry.getFileName(), (String)StringUtil.randomString())).build();
                }).put((Object)"clientName", (Object)digitalSalesRoom.getClientName()).put((Object)"externalReferenceCode", (Object)group.getExternalReferenceCode()).put((Object)"primaryColor", (Object)digitalSalesRoom.getPrimaryColor()).put((Object)"secondaryColor", (Object)digitalSalesRoom.getSecondaryColor()).build());
            }
        };
    }
}

