/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.digital.sales.room.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.headless.digital.sales.room.dto.v1_0.DigitalSalesRoom;
import com.liferay.headless.digital.sales.room.dto.v1_0.FileEntry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"application.name=Liferay.Headless.Digital.Sales.Room", "dto.class.name=com.liferay.headless.digital.sales.room.dto.v1_0.DigitalSalesRoom", "version=v1.0"}, service={DTOConverter.class})
public class DigitalSalesRoomDTOConverter
implements DTOConverter<Group, DigitalSalesRoom> {
    private static final Log _log = LogFactoryUtil.getLog(DigitalSalesRoomDTOConverter.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private File _file;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    public String getContentType() {
        return Group.class.getSimpleName();
    }

    public DigitalSalesRoom toDTO(final DTOConverterContext dtoConverterContext, final Group group) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_DSR_ROOM", group.getCompanyId());
        final ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(group.getExternalReferenceCode(), group.getGroupId(), objectDefinition.getObjectDefinitionId());
        if (objectEntry == null) {
            return null;
        }
        final Map values = objectEntry.getValues();
        return new DigitalSalesRoom(){
            {
                this.setAccountId(() -> GetterUtil.getLong(values.get("accountId")));
                this.setAccountName(() -> {
                    long accountId = GetterUtil.getLong(values.get("accountId"));
                    if (accountId == 0L) {
                        return null;
                    }
                    AccountEntry accountEntry = DigitalSalesRoomDTOConverter.this._accountEntryLocalService.fetchAccountEntry(accountId);
                    if (accountEntry == null) {
                        return null;
                    }
                    return accountEntry.getName();
                });
                this.setBanner(() -> DigitalSalesRoomDTOConverter.this._getFileEntry("banner", values));
                this.setChannelId(() -> GetterUtil.getLong(values.get("channelId")));
                this.setClientLogo(() -> DigitalSalesRoomDTOConverter.this._getFileEntry("clientLogo", values));
                this.setClientName(() -> GetterUtil.getString(values.get("clientName")));
                this.setCreateDate(() -> ((ObjectEntry)objectEntry).getCreateDate());
                this.setDescription(() -> group.getDescription(dtoConverterContext.getLocale()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setFriendlyUrlPath(() -> ((Group)group).getFriendlyURL());
                this.setId(() -> ((Group)group).getGroupId());
                this.setModifiedDate(() -> ((Group)group).getModifiedDate());
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setOwnerId(() -> ((ObjectEntry)objectEntry).getUserId());
                this.setOwnerName(() -> ((ObjectEntry)objectEntry).getUserName());
                this.setPrimaryColor(() -> GetterUtil.getString(values.get("primaryColor")));
                this.setSecondaryColor(() -> GetterUtil.getString(values.get("secondaryColor")));
            }
        };
    }

    private FileEntry _getFileEntry(String name, Map<String, Serializable> values) {
        long fileEntryId = GetterUtil.getLong((Object)values.get(name));
        if (fileEntryId == 0L) {
            return null;
        }
        try {
            final com.liferay.portal.kernel.repository.model.FileEntry serviceBuilderFileEntry = this._dlAppLocalService.fetchFileEntry(fileEntryId);
            if (serviceBuilderFileEntry == null) {
                return null;
            }
            return new FileEntry(){
                {
                    this.setFileBase64(() -> (String)NestedFieldsSupplier.supply((String)"fileBase64", fieldName -> Base64.encode((byte[])DigitalSalesRoomDTOConverter.this._file.getBytes(serviceBuilderFileEntry.getContentStream()))));
                    this.setFileName(() -> ((com.liferay.portal.kernel.repository.model.FileEntry)serviceBuilderFileEntry).getFileName());
                    this.setFileURL(() -> DLURLHelperUtil.getDownloadURL((com.liferay.portal.kernel.repository.model.FileEntry)serviceBuilderFileEntry, (FileVersion)serviceBuilderFileEntry.getLatestFileVersion(), null, (String)"", (boolean)true, (boolean)true));
                    this.setId(() -> ((com.liferay.portal.kernel.repository.model.FileEntry)serviceBuilderFileEntry).getFileEntryId());
                }
            };
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }
}

