/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cms.internal.resource.v1_0;

import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.headless.cms.dto.v1_0.BulkAction;
import com.liferay.headless.cms.dto.v1_0.BulkActionItem;
import com.liferay.headless.cms.dto.v1_0.BulkActionTask;
import com.liferay.headless.cms.dto.v1_0.DeleteBulkAction;
import com.liferay.headless.cms.internal.odata.entity.v1_0.BulkActionEntityModel;
import com.liferay.headless.cms.internal.resource.v1_0.BaseBulkActionResourceImpl;
import com.liferay.headless.cms.resource.v1_0.BulkActionResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.rest.dto.v1_0.SearchResult;
import com.liferay.portal.search.rest.resource.v1_0.SearchResultResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/bulk-action.properties"}, scope=ServiceScope.PROTOTYPE, service={BulkActionResource.class})
public class BulkActionResourceImpl
extends BaseBulkActionResourceImpl {
    private static final EntityModel _entityModel = new BulkActionEntityModel();
    private ObjectDefinition _bulkActionTaskItemObjectDefinition;
    private ObjectDefinition _bulkActionTaskObjectDefinition;
    @Reference
    private ImportTaskResource.Factory _importTaskResourceFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private SearchResultResource.Factory _searchResultResourceFactory;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public BulkActionTask postBulkAction(String search, Filter filter, BulkAction bulkAction) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (BulkAction.Type.DELETE_BULK_ACTION.equals((Object)bulkAction.getType())) {
            return this._executeDeleteBulkAction(bulkAction, this._getBulkActionItemsMap(bulkAction.getBulkActionItems(), filter, search, GetterUtil.getBoolean((Object)bulkAction.getSelectAll())));
        }
        throw new UnsupportedOperationException();
    }

    private BulkActionTask _addBulkActionTask(String type) throws Exception {
        final ObjectEntry objectEntry = this._objectEntryLocalService.addObjectEntry(0L, this.contextUser.getUserId(), this._getBulkActionTaskObjectDefinitionId(), 0L, null, (Map)HashMapBuilder.put((Object)"actionName", (Object)type).put((Object)"executionStatus", (Object)"STARTED").put((Object)"type", (Object)type).build(), new ServiceContext());
        final Map values = objectEntry.getValues();
        return new BulkActionTask(){
            {
                this.setActionName(() -> GetterUtil.getString(values.get("actionName")));
                this.setAuthor(() -> ((ObjectEntry)objectEntry).getUserName());
                this.setCreatedDate(() -> ((ObjectEntry)objectEntry).getCreateDate());
                this.setExecuteStatus(() -> GetterUtil.getString(values.get("executionStatus")));
                this.setExternalReferenceCode(() -> ((ObjectEntry)objectEntry).getExternalReferenceCode());
                this.setId(() -> ((ObjectEntry)objectEntry).getObjectEntryId());
                this.setType(() -> GetterUtil.getString(values.get("type")));
            }
        };
    }

    private void _addBulkActionTaskItem(long bulkActionTaskId, String classExternalReferenceCode, Long classPK, String executionStatus, long importTaskId, String name, long objectDefinitionId, String type) throws Exception {
        this._objectEntryLocalService.addObjectEntry(0L, this.contextUser.getUserId(), objectDefinitionId, 0L, null, (Map)HashMapBuilder.put((Object)"classExternalReferenceCode", (Object)classExternalReferenceCode).put((Object)"classPK", (Object)classPK).put((Object)"executionStatus", (Object)executionStatus).put((Object)"importTaskId", (Object)importTaskId).put((Object)"name", (Object)name).put((Object)"r_bulkActionTaskToBulkActionTaskItems_c_bulkActionTaskId", (Object)bulkActionTaskId).put((Object)"type", (Object)(type != null ? type : "ObjectEntryFolder")).build(), new ServiceContext());
    }

    private BulkActionTask _executeDeleteBulkAction(BulkAction bulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        if (MapUtil.isEmpty(bulkActionItemsMap)) {
            return new BulkActionTask();
        }
        DeleteBulkAction deleteBulkAction = (DeleteBulkAction)bulkAction;
        BulkActionTask bulkActionTask = this._addBulkActionTask(deleteBulkAction.getTypeAsString());
        ImportTaskResource importTaskResource = this._importTaskResourceFactory.create().httpServletRequest(this.contextHttpServletRequest).httpServletResponse(this.contextHttpServletResponse).uriInfo(this.contextUriInfo).user(this.contextUser).build();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            ImportTask importTask = importTaskResource.deleteImportTaskObject(this._getClassName(entry.getKey()), null, null, "ON_ERROR_CONTINUE", taskItemDelegateName, this.transform((Collection)entry.getValue(), bulkActionItem -> HashMapBuilder.put((Object)"id", (Object)bulkActionItem.getClassPK()).build()));
            for (BulkActionItem bulkActionItem2 : entry.getValue()) {
                this._addBulkActionTaskItem(bulkActionTask.getId(), bulkActionItem2.getClassExternalReferenceCode(), bulkActionItem2.getClassPK(), importTask.getExecuteStatusAsString(), importTask.getId(), bulkActionItem2.getName(), this._getBulkActionTaskItemObjectDefinitionId(), taskItemDelegateName);
            }
        }
        return bulkActionTask;
    }

    private Map<String, List<BulkActionItem>> _getBulkActionItemsMap(BulkActionItem[] bulkActionItems, Filter filter, String search, boolean selectAll) throws Exception {
        HashMap<String, List<BulkActionItem>> bulkActionItemsMap = new HashMap<String, List<BulkActionItem>>();
        if (selectAll && ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            if (filter == null) {
                throw new ValidationException("Filter is null");
            }
            SearchResultResource searchResultResource = this._searchResultResourceFactory.create().httpServletRequest(this.contextHttpServletRequest).httpServletResponse(this.contextHttpServletResponse).preferredLocale(this.contextAcceptLanguage.getPreferredLocale()).uriInfo(this.contextUriInfo).user(this.contextUser).build();
            Page searchPage = searchResultResource.getSearchPage(null, Boolean.valueOf(true), null, null, search, filter, Pagination.of((int)-1, (int)-1), null);
            for (SearchResult searchResult : searchPage.getItems()) {
                final JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(searchResult.getEmbedded()));
                bulkActionItemsMap.computeIfAbsent(searchResult.getEntryClassName(), key -> new ArrayList()).add(new BulkActionItem(){
                    {
                        this.setClassExternalReferenceCode(() -> jsonObject.getString("externalReferenceCode"));
                        this.setClassPK(() -> jsonObject.getLong("id"));
                    }
                });
            }
            return bulkActionItemsMap;
        }
        if (ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            return bulkActionItemsMap;
        }
        for (BulkActionItem bulkActionItem : bulkActionItems) {
            bulkActionItemsMap.computeIfAbsent(bulkActionItem.getClassName(), key -> new ArrayList()).add(bulkActionItem);
        }
        return bulkActionItemsMap;
    }

    private long _getBulkActionTaskItemObjectDefinitionId() throws Exception {
        if (this._bulkActionTaskItemObjectDefinition != null) {
            return this._bulkActionTaskItemObjectDefinition.getObjectDefinitionId();
        }
        this._bulkActionTaskItemObjectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_BULK_ACTION_TASK_ITEM", this.contextCompany.getCompanyId());
        return this._bulkActionTaskItemObjectDefinition.getObjectDefinitionId();
    }

    private long _getBulkActionTaskObjectDefinitionId() throws Exception {
        if (this._bulkActionTaskObjectDefinition != null) {
            return this._bulkActionTaskObjectDefinition.getObjectDefinitionId();
        }
        this._bulkActionTaskObjectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_BULK_ACTION_TASK", this.contextCompany.getCompanyId());
        return this._bulkActionTaskObjectDefinition.getObjectDefinitionId();
    }

    private String _getClassName(String key) {
        if (StringUtil.equals((String)key, (String)"com.liferay.object.model.ObjectEntryFolder")) {
            return "com.liferay.headless.object.dto.v1_0.ObjectEntryFolder";
        }
        return "com.liferay.object.rest.dto.v1_0.ObjectEntry";
    }

    private String _getTaskItemDelegateName(String key) throws Exception {
        if (StringUtil.equals((String)"com.liferay.object.model.ObjectEntryFolder", (String)key)) {
            return null;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByClassName(this.contextCompany.getCompanyId(), key);
        return objectDefinition.getName();
    }
}

