/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.UserAccount;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseUserAccountResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.UserAccountResource;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-account.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={UserAccountResource.class})
public class UserAccountResourceImpl
extends BaseUserAccountResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Group)")
    private ModelResourcePermission<Group> _groupModelResourcePermission;
    @Reference
    private GroupService _groupService;
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.UserAccountDTOConverter)")
    private DTOConverter<User, UserAccount> _userAccountDTOConverter;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private ModelResourcePermission<User> _userModelResourcePermission;
    @Reference
    private UserService _userService;

    @Override
    public void deleteAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserAccountByExternalReferenceCodeUserExternalReferenceCode(String assetLibraryExternalReferenceCode, String userExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userExternalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteAssetLibraryUserAccount(group.getGroupId(), user.getUserId());
    }

    @Override
    public void deleteAssetLibraryUserAccount(Long assetLibraryId, Long userId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._updateUser(assetLibraryId, userId, false);
    }

    @Override
    public UserAccount getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserAccountByExternalReferenceCodeUserExternalReferenceCode(String assetLibraryExternalReferenceCode, String userExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibraryUserAccount(group.getGroupId(), user.getUserId());
    }

    @Override
    public Page<UserAccount> getAssetLibraryByExternalReferenceCodeUserAccountsPage(String externalReferenceCode, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(externalReferenceCode);
        return this.getAssetLibraryUserAccountsPage(group.getGroupId(), keywords, search, pagination, sorts);
    }

    @Override
    public UserAccount getAssetLibraryUserAccount(Long assetLibraryId, Long userId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (!this._groupService.hasUserGroup(userId.longValue(), assetLibraryId.longValue())) {
            throw new NoSuchUserException("No user exists with user group ID " + userId);
        }
        return this._toUserAccount(assetLibraryId, this._userService.getUserById(userId.longValue()));
    }

    @Override
    @NestedField(parentClass=AssetLibrary.class, value="userAccounts")
    public Page<UserAccount> getAssetLibraryUserAccountsPage(@NestedFieldId(value="siteId") Long assetLibraryId, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._getUserAccountsPage(assetLibraryId, keywords, pagination, sorts);
    }

    @Override
    public UserAccount putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserAccountByExternalReferenceCodeUserExternalReferenceCode(String assetLibraryExternalReferenceCode, String userExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibraryUserAccount(group.getGroupId(), user.getUserId());
    }

    @Override
    public UserAccount putAssetLibraryUserAccount(Long assetLibraryId, Long userId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toUserAccount(assetLibraryId, this._updateUser(assetLibraryId, userId, true));
    }

    private Group _getGroup(String externalReferenceCode) throws Exception {
        Group group = this._groupService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No group exists with external reference code " + externalReferenceCode);
        }
        return group;
    }

    private Page<UserAccount> _getUserAccountsPage(Long groupId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ASSIGN_MEMBERS", groupId, "putAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"delete", this.addAction("ASSIGN_MEMBERS", groupId, "deleteAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", 0L, "getAssetLibraryUserAccountsPage", this._groupModelResourcePermission)).build(), booleanQuery -> booleanQuery.add((Query)new TermQueryImpl("groupIds", String.valueOf(groupId)), BooleanClauseOccur.MUST), null, (String)User.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toUserAccount(groupId, this._userService.getUserById(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private long[] _getUserGroupIds(User user, long assetLibraryId, boolean add) {
        HashSet<Long> groupIds = new HashSet<Long>();
        for (long groupId : user.getGroupIds()) {
            groupIds.add(groupId);
        }
        if (add) {
            groupIds.add(assetLibraryId);
        } else {
            groupIds.remove(assetLibraryId);
        }
        return ArrayUtil.toLongArray(groupIds);
    }

    private UserAccount _toUserAccount(long assetLibraryId, User user) throws Exception {
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("ASSIGN_MEMBERS", user.getGroupId(), "deleteAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", user.getUserId(), "getAssetLibraryUserAccount", this._userModelResourcePermission)).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)user.getUserId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        defaultDTOConverterContext.setAttribute("assetLibraryId", (Object)assetLibraryId);
        return (UserAccount)this._userAccountDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext);
    }

    private User _updateUser(Long assetLibraryId, Long userId, boolean add) throws Exception {
        User user = this._userService.getUserById(userId.longValue());
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(user.getBirthday());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        return this._userService.updateUser(user.getUserId(), user.getPassword(), null, null, user.isPasswordReset(), null, null, user.getScreenName(), user.getEmailAddress(), user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), user.getFirstName(), user.getMiddleName(), user.getLastName(), contact.getPrefixListTypeId(), contact.getSuffixListTypeId(), user.isMale(), birthdayCal.get(2), birthdayCal.get(5), birthdayCal.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), user.getJobTitle(), this._getUserGroupIds(user, assetLibraryId, add), user.getOrganizationIds(), null, null, user.getUserGroupIds(), serviceContext);
    }
}

