/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Path(value="/v1.0")
public abstract class BaseAssetLibraryResourceImpl
implements AssetLibraryResource {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetLibraryResourceImpl.class);

    @Operation(description="Deletes the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
    }

    @Operation(description="Deletes the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Unpins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryByExternalReferenceCodePin(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Unpins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/pins")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
    }

    @Operation(description="Retrieves the asset libraries. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries")
    @Produces(value={"application/json", "application/xml"})
    public Page<AssetLibrary> getAssetLibrariesPage(@Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the pinned asset libraries.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/pinned-by-me")
    @Produces(value={"application/json", "application/xml"})
    public Page<AssetLibrary> getAssetLibrariesPinnedByMePage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Retrieves the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body with the given external reference code. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        AssetLibrary existingAssetLibrary = this.getAssetLibraryByExternalReferenceCode(externalReferenceCode);
        if (assetLibrary.getDescription() != null) {
            existingAssetLibrary.setDescription(assetLibrary.getDescription());
        }
        if (assetLibrary.getDescription_i18n() != null) {
            existingAssetLibrary.setDescription_i18n(assetLibrary.getDescription_i18n());
        }
        if (assetLibrary.getExternalReferenceCode() != null) {
            existingAssetLibrary.setExternalReferenceCode(assetLibrary.getExternalReferenceCode());
        }
        if (assetLibrary.getName() != null) {
            existingAssetLibrary.setName(assetLibrary.getName());
        }
        if (assetLibrary.getName_i18n() != null) {
            existingAssetLibrary.setName_i18n(assetLibrary.getName_i18n());
        }
        this.preparePatch(assetLibrary, existingAssetLibrary);
        return this.putAssetLibraryByExternalReferenceCode(externalReferenceCode, existingAssetLibrary);
    }

    @Operation(description="Adds a new asset library")
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Replaces the asset library with information sent in the request body with the given external reference code. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Pins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryByExternalReferenceCodePin(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Pins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/{assetLibraryId}/pins")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
        return new AssetLibrary();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        if (contextHttpServletRequest != null && contextHttpServletRequest.getAttribute("CTX") == null) {
            contextHttpServletRequest.setAttribute("CTX", (Object)ServletContextPool.get((String)""));
        }
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(AssetLibrary assetLibrary, AssetLibrary existingAssetLibrary) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return this.unsafeTransformToLongArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (long[])this._unsafeTransformToPrimitiveArray(collection, unsafeFunction, long[].class);
    }

    private <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = this.unsafeTransform(collection, unsafeFunction);
        Object array = clazz.cast(Array.newInstance(clazz.getComponentType(), list.size()));
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

