/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.UserGroup;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseUserGroupResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.UserGroupResource;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-group.properties"}, scope=ServiceScope.PROTOTYPE, service={UserGroupResource.class})
public class UserGroupResourceImpl
extends BaseUserGroupResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Group)")
    private ModelResourcePermission<Group> _groupModelResourcePermission;
    @Reference
    private GroupService _groupService;
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.UserGroupDTOConverter)")
    private DTOConverter<com.liferay.portal.kernel.model.UserGroup, UserGroup> _userGroupDTOConverter;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.UserGroup)")
    private ModelResourcePermission<Group> _userGroupModelResourcePermission;
    @Reference
    private UserGroupService _userGroupService;

    @Override
    public void deleteAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserGroupByExternalReferenceCodeUserGroupExternalReferenceCode(String assetLibraryExternalReferenceCode, String userGroupExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        com.liferay.portal.kernel.model.UserGroup userGroup = this._userGroupService.getUserGroupByExternalReferenceCode(userGroupExternalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteAssetLibraryUserGroup(group.getGroupId(), userGroup.getUserGroupId());
    }

    @Override
    public void deleteAssetLibraryUserGroup(Long assetLibraryId, Long userGroupId) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._userGroupService.unsetGroupUserGroups(assetLibraryId.longValue(), new long[]{userGroupId});
    }

    @Override
    public UserGroup getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserGroupByExternalReferenceCodeUserGroupExternalReferenceCode(String assetLibraryExternalReferenceCode, String userGroupExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        com.liferay.portal.kernel.model.UserGroup userGroup = this._userGroupService.getUserGroupByExternalReferenceCode(userGroupExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkGroupUserGroup(group.getGroupId(), userGroup.getUserGroupId());
        return this._toUserGroup(userGroup);
    }

    @Override
    public Page<UserGroup> getAssetLibraryByExternalReferenceCodeUserGroupsPage(String externalReferenceCode, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(externalReferenceCode);
        return this._getUserGroupPage(group.getGroupId(), keywords, search, pagination, sorts);
    }

    @Override
    public UserGroup getAssetLibraryUserGroup(Long assetLibraryId, Long userGroupId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._checkGroupUserGroup(assetLibraryId, userGroupId);
        return this._toUserGroup(this._userGroupService.getUserGroup(userGroupId.longValue()));
    }

    @Override
    public Page<UserGroup> getAssetLibraryUserGroupsPage(Long assetLibraryId, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getUserGroupPage(assetLibraryId, keywords, search, pagination, sorts);
    }

    @Override
    public UserGroup putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserGroupByExternalReferenceCodeUserGroupExternalReferenceCode(String assetLibraryExternalReferenceCode, String userGroupExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        com.liferay.portal.kernel.model.UserGroup userGroup = this._userGroupService.getUserGroupByExternalReferenceCode(userGroupExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibraryUserGroup(group.getGroupId(), userGroup.getUserGroupId());
    }

    @Override
    public UserGroup putAssetLibraryUserGroup(Long assetLibraryId, Long userGroupId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this._userGroupService.addGroupUserGroups(assetLibraryId.longValue(), new long[]{userGroupId});
        return this._toUserGroup(this._userGroupService.getUserGroup(userGroupId.longValue()));
    }

    private void _checkGroupUserGroup(Long assetLibraryId, Long userGroupId) throws Exception {
        if (!this._userGroupLocalService.hasGroupUserGroup(assetLibraryId.longValue(), userGroupId.longValue())) {
            throw new NoSuchUserGroupException("No user group exists with user group ID " + userGroupId);
        }
    }

    private Group _getGroup(String externalReferenceCode) throws Exception {
        Group group = this._groupService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No group exists with external reference code " + externalReferenceCode);
        }
        return group;
    }

    private Page<UserGroup> _getUserGroupPage(long groupId, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ASSIGN_MEMBERS", groupId, "putAssetLibraryUserGroup", this._groupModelResourcePermission)).put((Object)"delete", this.addAction("ASSIGN_MEMBERS", groupId, "deleteAssetLibraryUserGroup", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", 0L, "getAssetLibraryUserGroupsPage", this._groupModelResourcePermission)).build(), booleanQuery -> booleanQuery.add((Query)new TermQueryImpl("groupIds", String.valueOf(groupId)), BooleanClauseOccur.MUST), null, (String)com.liferay.portal.kernel.model.UserGroup.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
        }, (Sort[])sorts, document -> this._toUserGroup(this._userGroupService.getUserGroup(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private UserGroup _toUserGroup(com.liferay.portal.kernel.model.UserGroup userGroup) throws Exception {
        return (UserGroup)this._userGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("ASSIGN_MEMBERS", userGroup.getGroupId(), "deleteAssetLibraryUserGroup", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", userGroup.getUserGroupId(), "getAssetLibraryUserGroup", this._userGroupModelResourcePermission)).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)userGroup.getUserGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

