/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.UserAccount;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseUserAccountResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.UserAccountResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-account.properties"}, scope=ServiceScope.PROTOTYPE, service={UserAccountResource.class})
public class UserAccountResourceImpl
extends BaseUserAccountResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Group)")
    private ModelResourcePermission<Group> _groupModelResourcePermission;
    @Reference
    private GroupService _groupService;
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.UserAccountDTOConverter)")
    private DTOConverter<User, UserAccount> _userAccountDTOConverter;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private ModelResourcePermission<User> _userModelResourcePermission;
    @Reference
    private UserService _userService;

    @Override
    public void deleteAssetLibraryUserAccount(String assetLibraryExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        this._updateUser(group.getGroupId(), user.getUserId(), false);
    }

    @Override
    public UserAccount getAssetLibraryUserAccount(String assetLibraryExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        this._checkAssetLibraryAdminOrAssetLibraryMember(group.getGroupId());
        User user = this._userLocalService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkAssetLibraryMember(group.getGroupId(), user.getUserId());
        return this._toUserAccount(group.getGroupId(), user);
    }

    @Override
    public Page<UserAccount> getAssetLibraryUserAccountsPage(String assetLibraryExternalReferenceCode, String keywords, String search, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        this._checkAssetLibraryAdminOrAssetLibraryMember(group.getGroupId());
        return this._getUserAccountsPage(group.getGroupId(), keywords, pagination, sorts);
    }

    @Override
    public UserAccount putAssetLibraryUserAccount(String assetLibraryExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        return this._toUserAccount(group.getGroupId(), this._updateUser(group.getGroupId(), user.getUserId(), true));
    }

    private void _checkAssetLibraryAdminOrAssetLibraryMember(long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.isGroupAdmin(groupId)) {
            return;
        }
        if (!this._userService.hasGroupUser(groupId, this.contextUser.getUserId())) {
            throw new PrincipalException.MustHavePermission(this.contextUser.getUserId(), new String[]{"VIEW"});
        }
    }

    private void _checkAssetLibraryMember(long groupId, long userId) throws Exception {
        if (!this._userLocalService.hasGroupUser(groupId, userId)) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"User ", userId, " is not associated to group ", groupId}));
        }
    }

    private Group _getGroup(String externalReferenceCode) throws Exception {
        Group group = this._groupService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No group exists with external reference code " + externalReferenceCode);
        }
        return group;
    }

    private Page<UserAccount> _getUserAccountsPage(Long groupId, String keywords, Pagination pagination, Sort[] sorts) {
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ASSIGN_MEMBERS", groupId, "putAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"delete", this.addAction("ASSIGN_MEMBERS", groupId, "deleteAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW_MEMBERS", groupId, "getAssetLibraryUserAccountsPage", this._groupModelResourcePermission)).build(), this.transform(this._userLocalService.searchBySocial(this.contextCompany.getCompanyId(), new long[]{groupId}, null, keywords, pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts)), user -> this._toUserAccount(groupId, (User)user)), (Pagination)pagination, (long)this._userLocalService.searchCountBySocial(this.contextCompany.getCompanyId(), new long[]{groupId}, null, keywords));
    }

    private long[] _getUserGroupIds(User user, long assetLibraryId, boolean add) {
        HashSet<Long> groupIds = new HashSet<Long>();
        for (long groupId : user.getGroupIds()) {
            groupIds.add(groupId);
        }
        if (add) {
            groupIds.add(assetLibraryId);
        } else {
            groupIds.remove(assetLibraryId);
        }
        return ArrayUtil.toLongArray(groupIds);
    }

    private OrderByComparator<User> _toOrderByComparator(Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Sort sort : sorts) {
            if (Objects.equals(sort.getFieldName(), "externalReferenceCode")) {
                objects.add(sort.getFieldName());
                objects.add(!sort.isReverse());
                continue;
            }
            if (Objects.equals(sort.getFieldName(), "id")) {
                objects.add("userId");
                objects.add(!sort.isReverse());
                continue;
            }
            if (!Objects.equals(sort.getFieldName(), "name")) continue;
            objects.add("firstName");
            objects.add(!sort.isReverse());
            objects.add("middleName");
            objects.add(!sort.isReverse());
            objects.add("lastName");
            objects.add(!sort.isReverse());
        }
        return OrderByComparatorFactoryUtil.create((String)UserTable.INSTANCE.getTableName(), (Object[])objects.toArray());
    }

    private UserAccount _toUserAccount(long assetLibraryId, User user) throws Exception {
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("ASSIGN_MEMBERS", user.getGroupId(), "deleteAssetLibraryUserAccount", this._groupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", user.getUserId(), "getAssetLibraryUserAccount", this._userModelResourcePermission)).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)user.getUserId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        defaultDTOConverterContext.setAttribute("assetLibraryId", (Object)assetLibraryId);
        return (UserAccount)this._userAccountDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext);
    }

    private User _updateUser(Long assetLibraryId, Long userAccountId, boolean add) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(user.getBirthday());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        return this._userService.updateUser(user.getUserId(), user.getPassword(), null, null, user.isPasswordReset(), null, null, user.getScreenName(), user.getEmailAddress(), user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), user.getFirstName(), user.getMiddleName(), user.getLastName(), contact.getPrefixListTypeId(), contact.getSuffixListTypeId(), user.isMale(), birthdayCal.get(2), birthdayCal.get(5), birthdayCal.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), user.getJobTitle(), this._getUserGroupIds(user, assetLibraryId, add), user.getOrganizationIds(), null, null, user.getUserGroupIds(), serviceContext);
    }
}

