/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.ConnectedSite;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseConnectedSiteResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.ConnectedSiteResource;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/connected-site.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ConnectedSiteResource.class})
public class ConnectedSiteResourceImpl
extends BaseConnectedSiteResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.ConnectedSiteDTOConverter)")
    private DTOConverter<DepotEntryGroupRel, ConnectedSite> _connectedSiteDTOConverter;
    @Reference
    private DepotEntryGroupRelService _depotEntryGroupRelService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;

    @Override
    public void deleteAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeConnectedSiteByExternalReferenceCodeConnectedSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String connectedSiteExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group connectedSiteGroup = this._groupLocalService.getGroupByExternalReferenceCode(connectedSiteExternalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteAssetLibraryConnectedSite(assetLibraryGroup.getGroupId(), connectedSiteGroup.getGroupId());
    }

    @Override
    public void deleteAssetLibraryConnectedSite(Long assetLibraryId, Long connectedSiteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntry.getDepotEntryId(), connectedSiteId.longValue());
        this._depotEntryGroupRelService.deleteDepotEntryGroupRel(depotEntryGroupRel.getDepotEntryGroupRelId());
    }

    @Override
    public ConnectedSite getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeConnectedSiteByExternalReferenceCodeConnectedSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String connectedSiteExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group connectedSiteGroup = this._groupLocalService.getGroupByExternalReferenceCode(connectedSiteExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibraryConnectedSite(assetLibraryGroup.getGroupId(), connectedSiteGroup.getGroupId());
    }

    @Override
    public Page<ConnectedSite> getAssetLibraryByExternalReferenceCodeConnectedSitesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibraryConnectedSitesPage(group.getGroupId(), pagination);
    }

    @Override
    public ConnectedSite getAssetLibraryConnectedSite(Long assetLibraryId, Long connectedSiteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntry.getDepotEntryId(), connectedSiteId.longValue());
        return this._toConnectedSite(depotEntry, depotEntryGroupRel);
    }

    @Override
    @NestedField(parentClass=AssetLibrary.class, value="connectedSites")
    public Page<ConnectedSite> getAssetLibraryConnectedSitesPage(@NestedFieldId(value="assetLibraryId") Long assetLibraryId, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        return Page.of(this.transform(this._depotEntryGroupRelService.getDepotEntryGroupRels(depotEntry, pagination.getStartPosition(), pagination.getEndPosition()), depotEntryGroupRel -> this._toConnectedSite(depotEntry, (DepotEntryGroupRel)depotEntryGroupRel)), (Pagination)pagination, (long)this._depotEntryGroupRelService.getDepotEntryGroupRelsCount(depotEntry));
    }

    @Override
    public ConnectedSite putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeConnectedSiteByExternalReferenceCodeConnectedSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String connectedSiteExternalReferenceCode, ConnectedSite connectedSite) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group connectedSiteGroup = this._groupLocalService.getGroupByExternalReferenceCode(connectedSiteExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibraryConnectedSite(assetLibraryGroup.getGroupId(), connectedSiteGroup.getGroupId(), connectedSite);
    }

    @Override
    public ConnectedSite putAssetLibraryConnectedSite(Long assetLibraryId, Long connectedSiteId, ConnectedSite connectedSite) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.addDepotEntryGroupRel(depotEntry.getDepotEntryId(), connectedSiteId.longValue());
        if (connectedSite.getSearchable() != null) {
            this._depotEntryGroupRelService.updateSearchable(depotEntryGroupRel.getDepotEntryGroupRelId(), connectedSite.getSearchable().booleanValue());
        }
        return this._toConnectedSite(depotEntry, depotEntryGroupRel);
    }

    private ConnectedSite _toConnectedSite(DepotEntry depotEntry, DepotEntryGroupRel depotEntryGroupRel) throws Exception {
        return (ConnectedSite)this._connectedSiteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibraryConnectedSite")).put((Object)"get", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibraryConnectedSite")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)depotEntry, "putAssetLibraryConnectedSite")).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)depotEntryGroupRel.getDepotEntryGroupRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

