/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.Site;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseSiteResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.SiteResource;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={SiteResource.class})
public class SiteResourceImpl
extends BaseSiteResourceImpl {
    @Reference
    private DepotEntryGroupRelService _depotEntryGroupRelService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.SiteDTOConverter)")
    private DTOConverter<DepotEntryGroupRel, Site> _siteDTOConverter;

    @Override
    public void deleteAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String siteExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group siteGroup = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteAssetLibrarySite(assetLibraryGroup.getGroupId(), siteGroup.getGroupId());
    }

    @Override
    public void deleteAssetLibrarySite(Long assetLibraryId, Long siteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntry.getDepotEntryId(), siteId.longValue());
        this._depotEntryGroupRelService.deleteDepotEntryGroupRel(depotEntryGroupRel.getDepotEntryGroupRelId());
    }

    @Override
    public Site getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String siteExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group siteGroup = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibrarySite(assetLibraryGroup.getGroupId(), siteGroup.getGroupId());
    }

    @Override
    public Page<Site> getAssetLibraryByExternalReferenceCodeSitesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibrarySitesPage(group.getGroupId(), pagination);
    }

    @Override
    public Site getAssetLibrarySite(Long assetLibraryId, Long siteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntry.getDepotEntryId(), siteId.longValue());
        return this._toSite(depotEntry, depotEntryGroupRel);
    }

    @Override
    @NestedField(parentClass=AssetLibrary.class, value="sites")
    public Page<Site> getAssetLibrarySitesPage(@NestedFieldId(value="siteId") Long assetLibraryId, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        return Page.of(this.transform(this._depotEntryGroupRelService.getDepotEntryGroupRels(depotEntry, pagination.getStartPosition(), pagination.getEndPosition()), depotEntryGroupRel -> this._toSite(depotEntry, (DepotEntryGroupRel)depotEntryGroupRel)), (Pagination)pagination, (long)this._depotEntryGroupRelService.getDepotEntryGroupRelsCount(depotEntry));
    }

    @Override
    public Site putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(String assetLibraryExternalReferenceCode, String siteExternalReferenceCode, Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        Group assetLibraryGroup = this._groupLocalService.getGroupByExternalReferenceCode(assetLibraryExternalReferenceCode, this.contextCompany.getCompanyId());
        Group siteGroup = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibrarySite(assetLibraryGroup.getGroupId(), siteGroup.getGroupId(), site);
    }

    @Override
    public Site putAssetLibrarySite(Long assetLibraryId, Long siteId, Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.addDepotEntryGroupRel(depotEntry.getDepotEntryId(), siteId.longValue());
        if (site.getSearchable() != null) {
            this._depotEntryGroupRelService.updateSearchable(depotEntryGroupRel.getDepotEntryGroupRelId(), site.getSearchable().booleanValue());
        }
        return this._toSite(depotEntry, depotEntryGroupRel);
    }

    private Site _toSite(DepotEntry depotEntry, DepotEntryGroupRel depotEntryGroupRel) throws Exception {
        return (Site)this._siteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibrarySite")).put((Object)"get", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrarySite")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)depotEntry, "putAssetLibrarySite")).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)depotEntryGroupRel.getDepotEntryGroupRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

