/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.asset.library.dto.v1_0.ConnectedSite;
import com.liferay.headless.asset.library.dto.v1_0.Settings;
import com.liferay.headless.asset.library.dto.v1_0.UserAccount;
import com.liferay.headless.asset.library.dto.v1_0.UserGroup;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents an Asset Library", value="AssetLibrary")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="AssetLibrary")
public class AssetLibrary
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField(description="The asset library's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's key.") String assetLibraryKey;
    @JsonIgnore
    private Supplier<String> _assetLibraryKeySupplier;
    @GraphQLField(description="The asset library's connected sites.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's connected sites.") ConnectedSite[] connectedSites;
    @JsonIgnore
    private Supplier<ConnectedSite[]> _connectedSitesSupplier;
    @GraphQLField(description="The asset library's creator user ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's creator user ID.") Long creatorUserId;
    @JsonIgnore
    private Supplier<Long> _creatorUserIdSupplier;
    @GraphQLField(description="The asset library's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time a field of the asset library changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time a field of the asset library changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The asset library's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's description.") String description;
    @JsonIgnore
    private Supplier<String> _descriptionSupplier;
    @GraphQLField(description="The localized asset library's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized asset library's description.") Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField(description="The asset library's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The asset library's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The asset library's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The localized asset library's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized asset library's name.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField(description="The number of this asset library's connected sites.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this asset library's connected sites.") Integer numberOfConnectedSites;
    @JsonIgnore
    private Supplier<Integer> _numberOfConnectedSitesSupplier;
    @GraphQLField(description="The number of this asset library's associated users.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this asset library's associated users.") Integer numberOfUserAccounts;
    @JsonIgnore
    private Supplier<Integer> _numberOfUserAccountsSupplier;
    @GraphQLField(description="The number of this asset library's associated user groups.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this asset library's associated user groups.") Integer numberOfUserGroups;
    @JsonIgnore
    private Supplier<Integer> _numberOfUserGroupsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Permission[] permissions;
    @JsonIgnore
    private Supplier<Permission[]> _permissionsSupplier;
    @GraphQLField(description="The asset library's settings.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's settings.") Settings settings;
    @JsonIgnore
    private Supplier<Settings> _settingsSupplier;
    @GraphQLField(description="The asset library's site ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's site ID.") Long siteId;
    @JsonIgnore
    private Supplier<Long> _siteIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @GraphQLField(description="The asset library's associated users.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's associated users.") UserAccount[] userAccounts;
    @JsonIgnore
    private Supplier<UserAccount[]> _userAccountsSupplier;
    @GraphQLField(description="The asset library's associated user groups.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's associated user groups.") UserGroup[] userGroups;
    @JsonIgnore
    private Supplier<UserGroup[]> _userGroupsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.asset.library.dto.v1_0.AssetLibrary", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static AssetLibrary toDTO(String json) {
        return (AssetLibrary)ObjectMapperUtil.readValue(AssetLibrary.class, (String)json);
    }

    public static AssetLibrary unsafeToDTO(String json) {
        return (AssetLibrary)ObjectMapperUtil.unsafeReadValue(AssetLibrary.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's key.")
    public String getAssetLibraryKey() {
        if (this._assetLibraryKeySupplier != null) {
            this.assetLibraryKey = this._assetLibraryKeySupplier.get();
            this._assetLibraryKeySupplier = null;
        }
        return this.assetLibraryKey;
    }

    public void setAssetLibraryKey(String assetLibraryKey) {
        this.assetLibraryKey = assetLibraryKey;
        this._assetLibraryKeySupplier = null;
    }

    @JsonIgnore
    public void setAssetLibraryKey(UnsafeSupplier<String, Exception> assetLibraryKeyUnsafeSupplier) {
        this._assetLibraryKeySupplier = () -> {
            try {
                return (String)assetLibraryKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's connected sites.")
    @Valid
    public ConnectedSite[] getConnectedSites() {
        if (this._connectedSitesSupplier != null) {
            this.connectedSites = this._connectedSitesSupplier.get();
            this._connectedSitesSupplier = null;
        }
        return this.connectedSites;
    }

    public void setConnectedSites(ConnectedSite[] connectedSites) {
        this.connectedSites = connectedSites;
        this._connectedSitesSupplier = null;
    }

    @JsonIgnore
    public void setConnectedSites(UnsafeSupplier<ConnectedSite[], Exception> connectedSitesUnsafeSupplier) {
        this._connectedSitesSupplier = () -> {
            try {
                return (ConnectedSite[])connectedSitesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's creator user ID.")
    public Long getCreatorUserId() {
        if (this._creatorUserIdSupplier != null) {
            this.creatorUserId = this._creatorUserIdSupplier.get();
            this._creatorUserIdSupplier = null;
        }
        return this.creatorUserId;
    }

    public void setCreatorUserId(Long creatorUserId) {
        this.creatorUserId = creatorUserId;
        this._creatorUserIdSupplier = null;
    }

    @JsonIgnore
    public void setCreatorUserId(UnsafeSupplier<Long, Exception> creatorUserIdUnsafeSupplier) {
        this._creatorUserIdSupplier = () -> {
            try {
                return (Long)creatorUserIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time a field of the asset library changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's description.")
    public String getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (String)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized asset library's description.")
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized asset library's name.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of this asset library's connected sites.")
    public Integer getNumberOfConnectedSites() {
        if (this._numberOfConnectedSitesSupplier != null) {
            this.numberOfConnectedSites = this._numberOfConnectedSitesSupplier.get();
            this._numberOfConnectedSitesSupplier = null;
        }
        return this.numberOfConnectedSites;
    }

    public void setNumberOfConnectedSites(Integer numberOfConnectedSites) {
        this.numberOfConnectedSites = numberOfConnectedSites;
        this._numberOfConnectedSitesSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfConnectedSites(UnsafeSupplier<Integer, Exception> numberOfConnectedSitesUnsafeSupplier) {
        this._numberOfConnectedSitesSupplier = () -> {
            try {
                return (Integer)numberOfConnectedSitesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of this asset library's associated users.")
    public Integer getNumberOfUserAccounts() {
        if (this._numberOfUserAccountsSupplier != null) {
            this.numberOfUserAccounts = this._numberOfUserAccountsSupplier.get();
            this._numberOfUserAccountsSupplier = null;
        }
        return this.numberOfUserAccounts;
    }

    public void setNumberOfUserAccounts(Integer numberOfUserAccounts) {
        this.numberOfUserAccounts = numberOfUserAccounts;
        this._numberOfUserAccountsSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfUserAccounts(UnsafeSupplier<Integer, Exception> numberOfUserAccountsUnsafeSupplier) {
        this._numberOfUserAccountsSupplier = () -> {
            try {
                return (Integer)numberOfUserAccountsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of this asset library's associated user groups.")
    public Integer getNumberOfUserGroups() {
        if (this._numberOfUserGroupsSupplier != null) {
            this.numberOfUserGroups = this._numberOfUserGroupsSupplier.get();
            this._numberOfUserGroupsSupplier = null;
        }
        return this.numberOfUserGroups;
    }

    public void setNumberOfUserGroups(Integer numberOfUserGroups) {
        this.numberOfUserGroups = numberOfUserGroups;
        this._numberOfUserGroupsSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfUserGroups(UnsafeSupplier<Integer, Exception> numberOfUserGroupsUnsafeSupplier) {
        this._numberOfUserGroupsSupplier = () -> {
            try {
                return (Integer)numberOfUserGroupsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Permission[] getPermissions() {
        if (this._permissionsSupplier != null) {
            this.permissions = this._permissionsSupplier.get();
            this._permissionsSupplier = null;
        }
        return this.permissions;
    }

    public void setPermissions(Permission[] permissions) {
        this.permissions = permissions;
        this._permissionsSupplier = null;
    }

    @JsonIgnore
    public void setPermissions(UnsafeSupplier<Permission[], Exception> permissionsUnsafeSupplier) {
        this._permissionsSupplier = () -> {
            try {
                return (Permission[])permissionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's settings.")
    @Valid
    public Settings getSettings() {
        if (this._settingsSupplier != null) {
            this.settings = this._settingsSupplier.get();
            this._settingsSupplier = null;
        }
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this._settingsSupplier = null;
    }

    @JsonIgnore
    public void setSettings(UnsafeSupplier<Settings, Exception> settingsUnsafeSupplier) {
        this._settingsSupplier = () -> {
            try {
                return (Settings)settingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's site ID.")
    public Long getSiteId() {
        if (this._siteIdSupplier != null) {
            this.siteId = this._siteIdSupplier.get();
            this._siteIdSupplier = null;
        }
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
        this._siteIdSupplier = null;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        this._siteIdSupplier = () -> {
            try {
                return (Long)siteIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @JsonGetter(value="type")
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's associated users.")
    @Valid
    public UserAccount[] getUserAccounts() {
        if (this._userAccountsSupplier != null) {
            this.userAccounts = this._userAccountsSupplier.get();
            this._userAccountsSupplier = null;
        }
        return this.userAccounts;
    }

    public void setUserAccounts(UserAccount[] userAccounts) {
        this.userAccounts = userAccounts;
        this._userAccountsSupplier = null;
    }

    @JsonIgnore
    public void setUserAccounts(UnsafeSupplier<UserAccount[], Exception> userAccountsUnsafeSupplier) {
        this._userAccountsSupplier = () -> {
            try {
                return (UserAccount[])userAccountsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's associated user groups.")
    @Valid
    public UserGroup[] getUserGroups() {
        if (this._userGroupsSupplier != null) {
            this.userGroups = this._userGroupsSupplier.get();
            this._userGroupsSupplier = null;
        }
        return this.userGroups;
    }

    public void setUserGroups(UserGroup[] userGroups) {
        this.userGroups = userGroups;
        this._userGroupsSupplier = null;
    }

    @JsonIgnore
    public void setUserGroups(UnsafeSupplier<UserGroup[], Exception> userGroupsUnsafeSupplier) {
        this._userGroupsSupplier = () -> {
            try {
                return (UserGroup[])userGroupsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssetLibrary)) {
            return false;
        }
        AssetLibrary assetLibrary = (AssetLibrary)object;
        return Objects.equals(this.toString(), assetLibrary.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        UserGroup[] userGroups;
        UserAccount[] userAccounts;
        Type type;
        Long siteId;
        Settings settings;
        Permission[] permissions;
        Integer numberOfUserGroups;
        Integer numberOfUserAccounts;
        Integer numberOfConnectedSites;
        Map<String, String> name_i18n;
        String name;
        Long id;
        String externalReferenceCode;
        Map<String, String> description_i18n;
        String description;
        Date dateModified;
        Date dateCreated;
        Long creatorUserId;
        ConnectedSite[] connectedSites;
        String assetLibraryKey;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(AssetLibrary._toJSON(actions));
        }
        if ((assetLibraryKey = this.getAssetLibraryKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetLibraryKey\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(assetLibraryKey));
            sb.append("\"");
        }
        if ((connectedSites = this.getConnectedSites()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"connectedSites\": ");
            sb.append("[");
            for (int i = 0; i < connectedSites.length; ++i) {
                sb.append(String.valueOf(connectedSites[i]));
                if (i + 1 >= connectedSites.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((creatorUserId = this.getCreatorUserId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorUserId\": ");
            sb.append((Object)creatorUserId);
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(description));
            sb.append("\"");
        }
        if ((description_i18n = this.getDescription_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(AssetLibrary._toJSON(description_i18n));
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(name));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(AssetLibrary._toJSON(name_i18n));
        }
        if ((numberOfConnectedSites = this.getNumberOfConnectedSites()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfConnectedSites\": ");
            sb.append((Object)numberOfConnectedSites);
        }
        if ((numberOfUserAccounts = this.getNumberOfUserAccounts()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfUserAccounts\": ");
            sb.append((Object)numberOfUserAccounts);
        }
        if ((numberOfUserGroups = this.getNumberOfUserGroups()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfUserGroups\": ");
            sb.append((Object)numberOfUserGroups);
        }
        if ((permissions = this.getPermissions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"permissions\": ");
            sb.append("[");
            for (int i = 0; i < permissions.length; ++i) {
                sb.append((Object)permissions[i]);
                if (i + 1 >= permissions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((settings = this.getSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"settings\": ");
            sb.append(String.valueOf(settings));
        }
        if ((siteId = this.getSiteId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)siteId);
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        if ((userAccounts = this.getUserAccounts()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userAccounts\": ");
            sb.append("[");
            for (int i = 0; i < userAccounts.length; ++i) {
                sb.append(String.valueOf(userAccounts[i]));
                if (i + 1 >= userAccounts.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((userGroups = this.getUserGroups()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userGroups\": ");
            sb.append("[");
            for (int i = 0; i < userGroups.length; ++i) {
                sb.append(String.valueOf(userGroups[i]));
                if (i + 1 >= userGroups.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(AssetLibrary._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (AssetLibrary._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(AssetLibrary._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(AssetLibrary._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AssetLibrary._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        ASSET_LIBRARY("AssetLibrary"),
        SPACE("Space");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

