/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents an Asset Library", value="AssetLibrary")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="AssetLibrary")
public class AssetLibrary
implements Serializable {
    @GraphQLField(description="The key of the asset library.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The key of the asset library.") String assetLibraryKey;
    @JsonIgnore
    private Supplier<String> _assetLibraryKeySupplier;
    @GraphQLField(description="The asset library's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time a field of the asset library changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time a field of the asset library changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The asset library's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's description.") String description;
    @JsonIgnore
    private Supplier<String> _descriptionSupplier;
    @GraphQLField(description="The localized asset library's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized asset library's description.") Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField(description="The asset library's site external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's site external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The asset library's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The asset library linked site ids.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library linked site ids.") Long[] linkedSiteIds;
    @JsonIgnore
    private Supplier<Long[]> _linkedSiteIdsSupplier;
    @GraphQLField(description="The asset library linked sites external reference codes.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library linked sites external reference codes.") String[] linkedSitesExternalReferenceCodes;
    @JsonIgnore
    private Supplier<String[]> _linkedSitesExternalReferenceCodesSupplier;
    @GraphQLField(description="The asset library's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The asset library's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The localized asset library's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized asset library's name.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField(description="The asset library's site ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The asset library's site ID.") Long siteId;
    @JsonIgnore
    private Supplier<Long> _siteIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.asset.library.dto.v1_0.AssetLibrary", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static AssetLibrary toDTO(String json) {
        return (AssetLibrary)ObjectMapperUtil.readValue(AssetLibrary.class, (String)json);
    }

    public static AssetLibrary unsafeToDTO(String json) {
        return (AssetLibrary)ObjectMapperUtil.unsafeReadValue(AssetLibrary.class, (String)json);
    }

    @Schema(description="The key of the asset library.")
    public String getAssetLibraryKey() {
        if (this._assetLibraryKeySupplier != null) {
            this.assetLibraryKey = this._assetLibraryKeySupplier.get();
            this._assetLibraryKeySupplier = null;
        }
        return this.assetLibraryKey;
    }

    public void setAssetLibraryKey(String assetLibraryKey) {
        this.assetLibraryKey = assetLibraryKey;
        this._assetLibraryKeySupplier = null;
    }

    @JsonIgnore
    public void setAssetLibraryKey(UnsafeSupplier<String, Exception> assetLibraryKeyUnsafeSupplier) {
        this._assetLibraryKeySupplier = () -> {
            try {
                return (String)assetLibraryKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time a field of the asset library changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's description.")
    public String getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (String)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized asset library's description.")
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's site external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library linked site ids.")
    public Long[] getLinkedSiteIds() {
        if (this._linkedSiteIdsSupplier != null) {
            this.linkedSiteIds = this._linkedSiteIdsSupplier.get();
            this._linkedSiteIdsSupplier = null;
        }
        return this.linkedSiteIds;
    }

    public void setLinkedSiteIds(Long[] linkedSiteIds) {
        this.linkedSiteIds = linkedSiteIds;
        this._linkedSiteIdsSupplier = null;
    }

    @JsonIgnore
    public void setLinkedSiteIds(UnsafeSupplier<Long[], Exception> linkedSiteIdsUnsafeSupplier) {
        this._linkedSiteIdsSupplier = () -> {
            try {
                return (Long[])linkedSiteIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library linked sites external reference codes.")
    public String[] getLinkedSitesExternalReferenceCodes() {
        if (this._linkedSitesExternalReferenceCodesSupplier != null) {
            this.linkedSitesExternalReferenceCodes = this._linkedSitesExternalReferenceCodesSupplier.get();
            this._linkedSitesExternalReferenceCodesSupplier = null;
        }
        return this.linkedSitesExternalReferenceCodes;
    }

    public void setLinkedSitesExternalReferenceCodes(String[] linkedSitesExternalReferenceCodes) {
        this.linkedSitesExternalReferenceCodes = linkedSitesExternalReferenceCodes;
        this._linkedSitesExternalReferenceCodesSupplier = null;
    }

    @JsonIgnore
    public void setLinkedSitesExternalReferenceCodes(UnsafeSupplier<String[], Exception> linkedSitesExternalReferenceCodesUnsafeSupplier) {
        this._linkedSitesExternalReferenceCodesSupplier = () -> {
            try {
                return (String[])linkedSitesExternalReferenceCodesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized asset library's name.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The asset library's site ID.")
    public Long getSiteId() {
        if (this._siteIdSupplier != null) {
            this.siteId = this._siteIdSupplier.get();
            this._siteIdSupplier = null;
        }
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
        this._siteIdSupplier = null;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        this._siteIdSupplier = () -> {
            try {
                return (Long)siteIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssetLibrary)) {
            return false;
        }
        AssetLibrary assetLibrary = (AssetLibrary)object;
        return Objects.equals(this.toString(), assetLibrary.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long siteId;
        Map<String, String> name_i18n;
        String name;
        String[] linkedSitesExternalReferenceCodes;
        Long[] linkedSiteIds;
        Long id;
        String externalReferenceCode;
        Map<String, String> description_i18n;
        String description;
        Date dateModified;
        Date dateCreated;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String assetLibraryKey = this.getAssetLibraryKey();
        if (assetLibraryKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetLibraryKey\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(assetLibraryKey));
            sb.append("\"");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(description));
            sb.append("\"");
        }
        if ((description_i18n = this.getDescription_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(AssetLibrary._toJSON(description_i18n));
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((linkedSiteIds = this.getLinkedSiteIds()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"linkedSiteIds\": ");
            sb.append("[");
            for (int i = 0; i < linkedSiteIds.length; ++i) {
                sb.append((Object)linkedSiteIds[i]);
                if (i + 1 >= linkedSiteIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((linkedSitesExternalReferenceCodes = this.getLinkedSitesExternalReferenceCodes()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"linkedSitesExternalReferenceCodes\": ");
            sb.append("[");
            for (int i = 0; i < linkedSitesExternalReferenceCodes.length; ++i) {
                sb.append("\"");
                sb.append(AssetLibrary._escape(linkedSitesExternalReferenceCodes[i]));
                sb.append("\"");
                if (i + 1 >= linkedSitesExternalReferenceCodes.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(AssetLibrary._escape(name));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(AssetLibrary._toJSON(name_i18n));
        }
        if ((siteId = this.getSiteId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)siteId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(AssetLibrary._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (AssetLibrary._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(AssetLibrary._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(AssetLibrary._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AssetLibrary._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

