/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.LangBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.task.DirectDeployTask;
import com.liferay.gradle.plugins.task.DockerCopyTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.net.URL;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayBasePlugin
implements Plugin<Project> {
    public static final String DEPLOY_TASK_NAME = "deploy";
    public static final String DOCKER_COPY_TASK_NAME = "dockerCopy";
    public static final String PORTAL_CONFIGURATION_NAME = "portal";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodeDefaultsPlugin.class);
        LangBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        SourceFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        ExtensionContainer extensionContainer = project.getExtensions();
        final LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.create("liferay", LiferayExtension.class, new Object[]{project});
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration portalConfiguration = (Configuration)configurationContainer.create(PORTAL_CONFIGURATION_NAME);
        this._configureConfigurationPortal(portalConfiguration);
        TaskProvider deployTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)DEPLOY_TASK_NAME, Copy.class);
        this._configureTaskDeployProvider(project, liferayExtension, (TaskProvider<Copy>)deployTaskProvider);
        String dockerContainerId = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)deployTaskProvider.getName(), (String)"docker.container.id");
        String dockerFilesDir = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)deployTaskProvider.getName(), (String)"docker.files.dir");
        if (Validator.isNotNull((String)dockerContainerId)) {
            TaskProvider dockerCopyTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)DOCKER_COPY_TASK_NAME, DockerCopyTask.class);
            this._configureTaskDeployProvider(liferayExtension, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<DockerCopyTask>)dockerCopyTaskProvider, dockerContainerId, dockerFilesDir);
        }
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DirectDeployTask.class, (Action)new Action<DirectDeployTask>(){

            public void execute(DirectDeployTask directDeployTask) {
                LiferayBasePlugin.this._configureTaskDirectDeploy(directDeployTask, liferayExtension);
            }
        });
        GradleUtil.applyScript((Project)project, (String)this._getScriptLiferayExtension(project), (Object)project);
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
                resolutionStrategy.eachDependency((Action)new Action<DependencyResolveDetails>(){

                    public void execute(DependencyResolveDetails dependencyResolveDetails) {
                        ModuleVersionSelector moduleVersionSelector = dependencyResolveDetails.getRequested();
                        String version = moduleVersionSelector.getVersion();
                        if (version.equals("default")) {
                            dependencyResolveDetails.useVersion(liferayExtension.getDefaultVersion(moduleVersionSelector));
                        }
                    }
                });
            }
        });
    }

    private void _configureConfigurationPortal(Configuration portalConfiguration) {
        portalConfiguration.setDescription("Configures the classpath from the local Liferay bundle.");
        portalConfiguration.setVisible(false);
    }

    private void _configureTaskDeployProvider(final LiferayExtension liferayExtension, final TaskProvider<Copy> deployTaskProvider, final TaskProvider<DockerCopyTask> dockerCopyTaskProvider, final String dockerContainerId, final String dockerFilesDir) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                if (dockerContainerId != null) {
                    deployCopy.finalizedBy(new Object[]{dockerCopyTaskProvider});
                    deployCopy.setEnabled(false);
                } else if (dockerFilesDir != null) {
                    deployCopy.into((Object)new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            String relativePath = FileUtil.relativize((File)liferayExtension.getDeployDir(), (File)liferayExtension.getLiferayHome());
                            return new File(dockerFilesDir, relativePath);
                        }
                    });
                }
            }
        });
        dockerCopyTaskProvider.configure((Action)new Action<DockerCopyTask>(){

            public void execute(final DockerCopyTask dockerCopyTask) {
                dockerCopyTask.dependsOn(new Object[]{deployTaskProvider});
                dockerCopyTask.setContainerId(dockerContainerId);
                dockerCopyTask.setDeployDir(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        StringBuilder sb = new StringBuilder();
                        sb.append(dockerCopyTask.getLiferayHome());
                        sb.append('/');
                        String relativePath = FileUtil.relativize((File)liferayExtension.getDeployDir(), (File)liferayExtension.getLiferayHome());
                        sb.append(relativePath);
                        String deployDir = sb.toString();
                        return deployDir.replace('\\', '/');
                    }
                });
                dockerCopyTask.setDescription("Deploys the project to the Docker container.");
                dockerCopyTask.setGroup("build");
                dockerCopyTask.setSourceFile(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        Copy deployCopy = (Copy)deployTaskProvider.get();
                        FileCollection fileCollection = deployCopy.getSource();
                        return fileCollection.getSingleFile();
                    }
                });
            }
        });
    }

    private void _configureTaskDeployProvider(final Project project, final LiferayExtension liferayExtension, TaskProvider<Copy> deployTaskProvider) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                deployCopy.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Logger logger = task.getLogger();
                        if (logger.isLifecycleEnabled()) {
                            Copy copy = (Copy)task;
                            logger.lifecycle("Files of {} deployed to {}", new Object[]{project, copy.getDestinationDir()});
                        }
                    }
                });
                deployCopy.into((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return liferayExtension.getDeployDir();
                    }
                });
                deployCopy.setDescription("Assembles the project and deploys it to Liferay.");
                deployCopy.setGroup("build");
            }
        });
    }

    private void _configureTaskDirectDeploy(DirectDeployTask directDeployTask, final LiferayExtension liferayExtension) {
        directDeployTask.setAppServerDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerDir();
            }
        });
        directDeployTask.setAppServerLibGlobalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerLibGlobalDir();
            }
        });
        directDeployTask.setAppServerPortalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerPortalDir();
            }
        });
        directDeployTask.setAppServerType(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return liferayExtension.getAppServerType();
            }
        });
    }

    private String _getScriptLiferayExtension(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append("com/liferay/gradle/plugins/dependencies/config-liferay");
        String portalVersion = PortalTools.getPortalVersion(project);
        if (Validator.isNotNull((String)portalVersion)) {
            sb.append('-');
            sb.append(portalVersion);
        }
        sb.append(".gradle");
        ClassLoader classLoader = LiferayBasePlugin.class.getClassLoader();
        URL url = classLoader.getResource(sb.toString());
        if (url != null) {
            return sb.toString();
        }
        return "com/liferay/gradle/plugins/dependencies/config-liferay.gradle";
    }
}

