/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.task;

import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.util.CollectionUtils;

@CacheableTask
public class DockerCopyTask
extends Exec {
    private Object _containerId;
    private Object _deployDir;
    private Object _liferayHome;
    private Object _sourceFile;

    public DockerCopyTask() {
        this.setExecutable("docker");
        this.setLifearyHome("/opt/liferay");
    }

    public void exec() {
        Logger logger = this.getLogger();
        if (logger.isLifecycleEnabled()) {
            logger.lifecycle("Running: {} {}", new Object[]{this.getExecutable(), CollectionUtils.join((String)" ", this._getCompleteArgs())});
        }
        this.setArgs(this._getCompleteArgs());
        super.exec();
        if (logger.isLifecycleEnabled()) {
            logger.lifecycle("Files of {} deployed to {}", new Object[]{this.getProject(), this.getDeployDir()});
        }
    }

    @Input
    public String getContainerId() {
        return GradleUtil.toString((Object)this._containerId);
    }

    @Input
    public String getDeployDir() {
        return GradleUtil.toString((Object)this._deployDir);
    }

    @Input
    public String getLiferayHome() {
        return GradleUtil.toString((Object)this._liferayHome);
    }

    @Internal
    public File getSourceFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceFile);
    }

    public void setContainerId(Object containerId) {
        this._containerId = containerId;
    }

    public void setDeployDir(Object deployDir) {
        this._deployDir = deployDir;
    }

    public void setLifearyHome(Object liferayHome) {
        this._liferayHome = liferayHome;
    }

    public void setSourceFile(Object sourceFile) {
        this._sourceFile = sourceFile;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("cp");
        File sourceFile = this.getSourceFile();
        args.add(FileUtil.getAbsolutePath((File)sourceFile));
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContainerId());
        sb.append(':');
        sb.append(this.getDeployDir());
        sb.append('/');
        sb.append(sourceFile.getName());
        args.add(sb.toString());
        return args;
    }
}

