/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal.util;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;

public class IncludeResourceCompileIncludeInstruction {
    private final Callable<Boolean> _expandCallable;
    private final Callable<Iterable<File>> _filesIterable;

    public IncludeResourceCompileIncludeInstruction(Callable<Iterable<File>> filesIterable, Callable<Boolean> expandCallable) {
        this._filesIterable = filesIterable;
        this._expandCallable = expandCallable;
    }

    public String toString() {
        boolean expand = false;
        Iterable<File> files = null;
        try {
            expand = this._expandCallable.call();
            files = this._filesIterable.call();
        }
        catch (Exception exception) {
            throw new GradleException("Unable to build instruction", (Throwable)exception);
        }
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (expand) {
                sb.append('@');
            } else {
                sb.append("lib/=");
            }
            String absolutePath = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                absolutePath = absolutePath.replace(File.separatorChar, '/');
            }
            sb.append(absolutePath);
            if (!expand) {
                sb.append(";lib:=true");
                continue;
            }
            sb.append("!/!META-INF/versions/*");
        }
        return sb.toString();
    }
}

