/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.docker;

import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class DockerListImage
extends AbstractDockerRemoteApiTask {
    private final Property<String> _imageIdProperty;
    private final ListProperty<Image> _imagesProperty;
    private final Property<Boolean> _withDanglingFilter;

    public DockerListImage() {
        Project project = this.getProject();
        ObjectFactory objectFactory = project.getObjects();
        this._imageIdProperty = objectFactory.property(String.class);
        this._imagesProperty = objectFactory.listProperty(Image.class);
        this._withDanglingFilter = objectFactory.property(Boolean.class);
        Action<Image> action = new Action<Image>(){

            public void execute(Image image) {
                DockerListImage.this._imageIdProperty.set((Object)image.getId());
                DockerListImage.this._imagesProperty.add((Object)image);
            }
        };
        this.onNext((Action)action);
    }

    @Internal
    public String getImageId() {
        return (String)this._imageIdProperty.get();
    }

    @Input
    public List<Image> getImages() {
        return (List)this._imagesProperty.get();
    }

    public void runRemoteCommand() {
        DockerClient dockerClient = this.getDockerClient();
        ListImagesCmd listImagesCmd = dockerClient.listImagesCmd();
        listImagesCmd.withDanglingFilter((Boolean)this._withDanglingFilter.getOrElse((Object)true));
        if (this.getNextHandler() != null) {
            List images = (List)listImagesCmd.exec();
            for (Image image : images) {
                Action action = this.getNextHandler();
                action.execute((Object)image);
            }
        }
    }

    public boolean withDanglingFilter() {
        return (Boolean)this._withDanglingFilter.get();
    }
}

