/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util.copy;

import com.liferay.gradle.util.hash.HashUtil;
import com.liferay.gradle.util.hash.HashValue;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;

public class HashifyAction
implements Action<FileCopyDetails> {
    private final PathMatcher _pathMatcher;

    public HashifyAction(String fileNameGlob) {
        FileSystem fileSystem = FileSystems.getDefault();
        this._pathMatcher = fileSystem.getPathMatcher("glob:" + fileNameGlob);
    }

    public void execute(FileCopyDetails fileCopyDetails) {
        if (!this._pathMatcher.matches(Paths.get(fileCopyDetails.getName(), new String[0]))) {
            return;
        }
        fileCopyDetails.setName(this._getHashedFileName(fileCopyDetails));
    }

    private String _getHashedFileName(FileCopyDetails fileCopyDetails) {
        HashValue hashValue = HashUtil.sha1((File)fileCopyDetails.getFile());
        String fileName = fileCopyDetails.getName();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName + '.' + hashValue.asHexString();
        }
        String extension = fileName.substring(index + 1);
        String shortFileName = fileName.substring(0, index);
        return shortFileName + '.' + hashValue.asHexString() + '.' + extension;
    }
}

