/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtil {
    public static final String BLANK = "";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String COMMA_AND_SPACE = ", ";
    public static final String FORWARD_SLASH = "/";
    public static final String NEW_LINE = "\n";
    public static final String STAR = "*";
    public static final String UNDERSCORE = "_";
    private static final Pattern _camelCasePattern = Pattern.compile("(?<=[a-z])(?=[A-Z])|(?=[A-Z][a-z])");

    public static String capitalize(String s) {
        if (s == null || ((String)s).isEmpty()) {
            return BLANK;
        }
        char firstChar = ((String)s).charAt(0);
        if (Character.isLowerCase(firstChar)) {
            s = Character.toUpperCase(firstChar) + ((String)s).substring(1);
        }
        return s;
    }

    public static String concat(Object ... objects) {
        if (objects.length == 0) {
            return BLANK;
        }
        if (objects.length == 1) {
            return String.valueOf(objects[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object);
        }
        return sb.toString();
    }

    public static String getDockerSafeName(String name) {
        Matcher matcher = _camelCasePattern.matcher(name);
        String dockerSafeName = matcher.replaceAll("-");
        if (name.charAt(0) != '-' && dockerSafeName.charAt(0) == '-' && dockerSafeName.length() > 1) {
            dockerSafeName = dockerSafeName.substring(1);
        }
        return dockerSafeName.toLowerCase();
    }

    public static boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isUrl(String url) {
        if (StringUtil.isBlank(url) || !url.contains(COLON)) {
            return false;
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static String join(String delimiter, Collection<?> objects) {
        return StringUtil.join(delimiter, objects.stream());
    }

    public static String join(String delimiter, Object[] objects) {
        return StringUtil.join(delimiter, Arrays.stream(objects));
    }

    public static String join(String delimiter, Stream<?> stream) {
        return stream.map(String::valueOf).collect(Collectors.joining(delimiter));
    }

    public static String quote(Object object) {
        return "\"" + object + "\"";
    }

    public static String read(InputStream inputStream) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        int offset = 0;
        while ((count = inputStream.read(buffer, offset, buffer.length - offset)) != -1) {
            if ((offset += count) != buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length << 1];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        if (offset == 0) {
            return BLANK;
        }
        return new String(buffer, 0, offset, "UTF-8");
    }

    public static List<String> split(String s) {
        return StringUtil.split(s, COMMA);
    }

    public static List<String> split(String s, String delimiter) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        if ((s = s.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.split(COMMA));
    }

    public static String suffixIfNotBlank(String s, String suffix) {
        return StringUtil.suffixIfNotBlank(s, UNDERSCORE, suffix);
    }

    public static String suffixIfNotBlank(String s, String separator, String suffix) {
        if (StringUtil.isBlank(suffix)) {
            return s;
        }
        return StringUtil.concat(s, separator, suffix);
    }

    public static String toAlphaNumericLowerCase(String value) {
        return StringUtil.toLowerCase(value.replaceAll("[^a-zA-Z0-9]", BLANK));
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                return s.toLowerCase(Locale.getDefault());
            }
            if (c < 'A' || c > 'Z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c + 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String toString(List<String> strings) {
        Stream stream = strings.stream();
        return stream.collect(Collectors.joining(COMMA_AND_SPACE));
    }
}

