/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ClientExtensionProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ExtProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.WarsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.release.util.ReleaseEntry;
import com.liferay.release.util.ReleaseUtil;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;

public class WorkspaceExtension {
    private static final File _BUNDLE_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/bundles");
    private static final boolean _BUNDLE_DIST_INCLUDE_METADATA = false;
    private static final String _BUNDLE_DIST_ROOT_DIR_NAME = null;
    private static final File _DOCKER_DIR = new File("build" + File.separator + "docker");
    private static final boolean _DOCKER_PULL_POLICY = true;
    private static final String _NODE_PACKAGE_MANAGER = "yarn";
    private final Object _appServerTomcatVersion;
    private Object _bundleCacheDir;
    private Object _bundleChecksumSHA512;
    private Object _bundleDistIncludeMetadata;
    private Object _bundleDistRootDirName;
    private Object _bundleUrl;
    private Object _configsDir;
    private Iterable<String> _dirExcludesGlobs;
    private Object _dockerContainerId;
    private Object _dockerDir;
    private Object _dockerImageId;
    private Object _dockerImageLiferay;
    private Object _dockerLocalRegistryAddress;
    private Object _dockerPullPolicy;
    private Object _dockerUserAccessToken;
    private Object _dockerUserName;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private Object _nodePackageManager;
    private Object _product;
    private final Set<ProjectConfigurator> _projectConfigurators = new LinkedHashSet<ProjectConfigurator>();
    private final Plugin<Project> _rootProjectConfigurator;
    private Object _targetPlatformVersion;
    private Object _virtualInstanceId;

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._product = this._getProperty((Object)settings, "product", (String)null);
        this._projectConfigurators.add(new ClientExtensionProjectConfigurator(settings));
        this._projectConfigurators.add(new ExtProjectConfigurator(settings));
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._projectConfigurators.add(new WarsProjectConfigurator(settings));
        this._appServerTomcatVersion = GradleUtil.getProperty((ExtensionAware)settings, (String)"app.server.tomcat.version");
        this._bundleCacheDir = this._getProperty((Object)settings, "bundle.cache.dir", _BUNDLE_CACHE_DIR);
        this._bundleChecksumSHA512 = this._getProperty(settings, "bundle.checksum.sha512");
        this._bundleDistIncludeMetadata = this._getProperty((Object)settings, "bundle.dist.include.metadata", false);
        this._bundleDistRootDirName = this._getProperty((Object)settings, "bundle.dist.root.dir", _BUNDLE_DIST_ROOT_DIR_NAME);
        this._bundleUrl = this._getProperty(settings, "bundle.url");
        this._configsDir = this._getProperty((Object)settings, "configs.dir", "configs");
        this._dirExcludesGlobs = StringUtil.split(GradleUtil.toString((Object)this._getProperty(settings, "dir.excludes.globs")));
        this._dockerDir = this._getProperty((Object)settings, "docker.dir", _DOCKER_DIR);
        this._dockerImageLiferay = this._getProperty(settings, "docker.image.liferay");
        this._dockerLocalRegistryAddress = this._getProperty(settings, "docker.local.registry.address");
        this._dockerPullPolicy = this._getProperty((Object)settings, "docker.pull.policy", true);
        this._dockerUserAccessToken = this._getProperty(settings, "docker.user.access.token");
        this._dockerUserName = this._getProperty(settings, "docker.username");
        this._environment = this._getProperty((Object)settings, "environment", "local");
        this._homeDir = this._getProperty((Object)settings, "home.dir", "bundles");
        this._nodePackageManager = this._getProperty((Object)settings, "node.package.manager", _NODE_PACKAGE_MANAGER);
        this._targetPlatformVersion = this._getProperty(settings, "target.platform.version");
        this._virtualInstanceId = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.virtual.instance.id");
        this._gradle.projectsEvaluated((Closure)new Closure<Void>((Object)this._gradle){

            public void doCall() {
                Project rootProject = WorkspaceExtension.this._gradle.getRootProject();
                Logger logger = rootProject.getLogger();
                if (!logger.isLifecycleEnabled()) {
                    return;
                }
                String product = WorkspaceExtension.this.getProduct();
                if (product == null) {
                    logger.lifecycle("The property `liferay.workspace.product` has not been set. It is recommended to set this property in gradle.properties in the workspace directory. See LPS-111700.");
                    return;
                }
                String overridePropertyInfo = "The %s property is currently overriding the default value managed by the liferay.workspace.product setting.";
                if (!Objects.equals(WorkspaceExtension.this.getAppServerTomcatVersion(), ReleaseUtil.getFromReleaseEntry((String)product, ReleaseEntry::getAppServerTomcatVersion))) {
                    logger.lifecycle(String.format(overridePropertyInfo, "app.server.tomcat.version"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getBundleChecksumSHA512(), ReleaseUtil.getFromReleaseEntry((String)product, ReleaseEntry::getBundleChecksumSHA512))) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.bundle.checksum.sha512"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getBundleUrl(), ReleaseUtil.getFromReleaseEntry((String)product, ReleaseEntry::getBundleURL))) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.bundle.url"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getDockerImageLiferay(), ReleaseUtil.getFromReleaseEntry((String)product, ReleaseEntry::getLiferayDockerImage))) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.docker.image.liferay"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getTargetPlatformVersion(), ReleaseUtil.getFromReleaseEntry((String)product, ReleaseEntry::getTargetPlatformVersion))) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.target.platform.version"));
                }
            }
        });
        this._rootProjectConfigurator = new RootProjectConfigurator(settings);
    }

    public String getAppServerTomcatVersion() {
        if (Objects.isNull(this._appServerTomcatVersion)) {
            return (String)ReleaseUtil.getFromReleaseEntry((String)this.getProduct(), ReleaseEntry::getAppServerTomcatVersion);
        }
        return GradleUtil.toString((Object)this._appServerTomcatVersion);
    }

    public File getBundleCacheDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._bundleCacheDir);
    }

    public String getBundleChecksumSHA512() {
        if (Objects.isNull(this._bundleChecksumSHA512)) {
            return (String)ReleaseUtil.getFromReleaseEntry((String)this.getProduct(), ReleaseEntry::getBundleChecksumSHA512);
        }
        return GradleUtil.toString((Object)this._bundleChecksumSHA512);
    }

    public String getBundleDistRootDirName() {
        return GradleUtil.toString((Object)this._bundleDistRootDirName);
    }

    public String getBundleUrl() {
        if (Objects.isNull(this._bundleUrl)) {
            return (String)ReleaseUtil.getFromReleaseEntry((String)this.getProduct(), ReleaseEntry::getBundleURL);
        }
        return GradleUtil.toString((Object)this._bundleUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._configsDir);
    }

    public List<String> getDirExcludesGlobs() {
        return GradleUtil.toStringList(this._dirExcludesGlobs);
    }

    public String getDockerContainerId() {
        return GradleUtil.toString((Object)this._dockerContainerId);
    }

    public File getDockerDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._dockerDir);
    }

    public String getDockerImageId() {
        return GradleUtil.toString((Object)this._dockerImageId);
    }

    public String getDockerImageLiferay() {
        if (Objects.isNull(this._dockerImageLiferay)) {
            return (String)ReleaseUtil.getFromReleaseEntry((String)this.getProduct(), ReleaseEntry::getLiferayDockerImage);
        }
        return GradleUtil.toString((Object)this._dockerImageLiferay);
    }

    public String getDockerLocalRegistryAddress() {
        return GradleUtil.toString((Object)this._dockerLocalRegistryAddress);
    }

    public boolean getDockerPullPolicy() {
        return GradleUtil.toBoolean(this._dockerPullPolicy);
    }

    public String getDockerUserAccessToken() {
        return GradleUtil.toString((Object)this._dockerUserAccessToken);
    }

    public String getDockerUserName() {
        return GradleUtil.toString((Object)this._dockerUserName);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._homeDir);
    }

    public String getNodePackageManager() {
        return GradleUtil.toString((Object)this._nodePackageManager);
    }

    public String getProduct() {
        return GradleUtil.toString((Object)this._product);
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public Plugin<Project> getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public String getTargetPlatformVersion() {
        if (Objects.isNull(this._targetPlatformVersion)) {
            return (String)ReleaseUtil.getFromReleaseEntry((String)this.getProduct(), ReleaseEntry::getTargetPlatformVersion);
        }
        return GradleUtil.toString((Object)this._targetPlatformVersion);
    }

    public String getVirtualInstanceId() {
        return GradleUtil.toString((Object)this._virtualInstanceId);
    }

    public boolean isBundleDistIncludeMetadata() {
        return GradleUtil.toBoolean(this._bundleDistIncludeMetadata);
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleCacheDir(Object bundleCacheDir) {
        this._bundleCacheDir = bundleCacheDir;
    }

    public void setBundleChecksumSHA512(Object bundleChecksumSHA512) {
        this._bundleChecksumSHA512 = bundleChecksumSHA512;
    }

    public void setBundleDistIncludeMetadata(Object bundleDistIncludeMetadata) {
        this._bundleDistIncludeMetadata = bundleDistIncludeMetadata;
    }

    public void setBundleDistRootDirName(Object bundleDistRootDirName) {
        this._bundleDistRootDirName = bundleDistRootDirName;
    }

    public void setBundleUrl(Object bundleUrl) {
        this._bundleUrl = bundleUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setDirExcludesGlobs(Iterable<String> dirExcludesGlobs) {
        this._dirExcludesGlobs = dirExcludesGlobs;
    }

    public void setDockerContainerId(Object dockerContainerId) {
        this._dockerContainerId = dockerContainerId;
    }

    public void setDockerDir(Object dockerDir) {
        this._dockerDir = dockerDir;
    }

    public void setDockerImageId(Object dockerImageId) {
        this._dockerImageId = dockerImageId;
    }

    public void setDockerImageLiferay(Object dockerImageLiferay) {
        this._dockerImageLiferay = dockerImageLiferay;
    }

    public void setDockerLocalRegistryAddress(Object dockerLocalRegistryAddress) {
        this._dockerLocalRegistryAddress = dockerLocalRegistryAddress;
    }

    public void setDockerPullPolicy(Object dockerPullPolicy) {
        this._dockerPullPolicy = dockerPullPolicy;
    }

    public void setDockerUserAccessToken(Object dockerUserAccessToken) {
        this._dockerUserAccessToken = dockerUserAccessToken;
    }

    public void setDockerUserName(Object dockerUserName) {
        this._dockerUserName = dockerUserName;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }

    public void setNodePackageManager(Object nodePackageManager) {
        this._nodePackageManager = nodePackageManager;
    }

    public void setProduct(Object product) {
        this._product = product;
    }

    public void setTargetPlatformVersion(Object targetPlatformVersion) {
        this._targetPlatformVersion = targetPlatformVersion;
    }

    public void setVirtualInstanceId(Object virtualInstanceId) {
        this._virtualInstanceId = virtualInstanceId;
    }

    private Object _getProperty(Object object, String keySuffix) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix);
    }

    private boolean _getProperty(Object object, String keySuffix, boolean defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }

    private Object _getProperty(Object object, String keySuffix, File defaultValue) {
        Object value = GradleUtil.getProperty(object, "liferay.workspace." + keySuffix);
        if (value instanceof String && Validator.isNull((String)((String)value))) {
            value = null;
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String _getProperty(Object object, String keySuffix, String defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }
}

