/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.YarnPlugin;
import com.liferay.gradle.plugins.node.task.NpmInstallTask;
import com.liferay.gradle.plugins.node.task.PackageRunTask;
import com.liferay.gradle.plugins.node.task.PackageRunTestTask;
import com.liferay.gradle.plugins.node.task.YarnInstallTask;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.task.SetUpYarnTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayWorkspaceYarnPlugin
extends YarnPlugin {
    public static final String SET_UP_YARN_TASK_NAME = "setUpYarn";
    public static final String YARN_INSTALL_TASK_NAME = "yarnInstall";

    public void apply(Project project) {
        super.apply(project);
        GradleUtil.applyPlugin((Project)project, NodeDefaultsPlugin.class);
        TaskProvider setUpYarnTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)SET_UP_YARN_TASK_NAME, SetUpYarnTask.class);
        TaskProvider yarnInstallTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)YARN_INSTALL_TASK_NAME, YarnInstallTask.class);
        this._configureTaskYarnInstallProvider(project, (TaskProvider<YarnInstallTask>)yarnInstallTaskProvider, (TaskProvider<SetUpYarnTask>)setUpYarnTaskProvider);
        project.allprojects(project1 -> this._configureNodeProject((Project)project1, (TaskProvider<YarnInstallTask>)yarnInstallTaskProvider));
    }

    private void _configureNodeProject(Project project, TaskProvider<YarnInstallTask> yarnInstallTaskProvider) {
        project.afterEvaluate(project1 -> {
            TaskContainer taskContainer = project1.getTasks();
            taskContainer.withType(NpmInstallTask.class, npmInstallTask -> {
                NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)npmInstallTask.getProject(), NodeExtension.class);
                nodeExtension.setUseNpm((Object)false);
                npmInstallTask.finalizedBy(new Object[]{yarnInstallTaskProvider});
            });
            taskContainer.withType(PackageRunTask.class, packageRunTask -> {
                if (packageRunTask instanceof PackageRunTestTask) {
                    return;
                }
                packageRunTask.mustRunAfter(new Object[]{yarnInstallTaskProvider});
            });
        });
    }

    private void _configureTaskYarnInstallProvider(Project project, TaskProvider<YarnInstallTask> yarnInstallTaskProvider, TaskProvider<SetUpYarnTask> setUpYarnTaskProvider) {
        yarnInstallTaskProvider.configure(yarnInstallTask -> {
            block4: {
                yarnInstallTask.dependsOn(new Object[]{setUpYarnTaskProvider});
                try {
                    File file = new File(project.getProjectDir(), "yarn.lock");
                    if (file.exists()) {
                        String contents = new String(Files.readAllBytes(file.toPath()));
                        yarnInstallTask.setFrozenLockFile((Object)(!contents.equals("") ? 1 : 0));
                    } else {
                        yarnInstallTask.setFrozenLockFile((Object)false);
                    }
                }
                catch (IOException ioException) {
                    Logger logger = project.getLogger();
                    if (!logger.isWarnEnabled()) break block4;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unable to read yarn.lock.");
                    logger.warn(sb.toString());
                }
            }
        });
    }
}

