/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.util.CollectionUtils;

public class FormatSourceTask
extends JavaExec {
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public FormatSourceTask() {
        Property mainClass = this.getMainClass();
        mainClass.set((Object)"com.liferay.source.formatter.SourceFormatter");
    }

    public void addSourceFormatterProperty(String key, String value) {
        List<String> sourceFormatterProperties = this.getSourceFormatterProperties();
        sourceFormatterProperties.add(key + "=" + value);
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @Internal
    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceFormatterArgs.getBaseDirName());
    }

    @Input
    @Optional
    public String getBaseDirName() {
        return this._sourceFormatterArgs.getBaseDirName();
    }

    @Input
    @Optional
    public List<String> getCheckCategoryNames() {
        return this._sourceFormatterArgs.getCheckCategoryNames();
    }

    @Input
    @Optional
    public List<String> getCheckNames() {
        return this._sourceFormatterArgs.getCheckNames();
    }

    @Input
    @Optional
    public List<String> getFileExtensions() {
        return this._sourceFormatterArgs.getFileExtensions();
    }

    @Input
    @Optional
    public List<String> getFileNames() {
        return this._sourceFormatterArgs.getFileNames();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFiles() {
        Project project = this.getProject();
        List<String> fileNames = this._sourceFormatterArgs.getFileNames();
        if (fileNames == null) {
            fileNames = Collections.emptyList();
        }
        return project.files(new Object[]{fileNames});
    }

    @Input
    @Optional
    public String getGitWorkingBranchName() {
        return this._sourceFormatterArgs.getGitWorkingBranchName();
    }

    @Input
    public int getMaxLineLength() {
        return this._sourceFormatterArgs.getMaxLineLength();
    }

    @Input
    public int getProcessorThreadCount() {
        return this._sourceFormatterArgs.getProcessorThreadCount();
    }

    @Input
    @Optional
    public List<String> getSourceFormatterProperties() {
        return this._sourceFormatterArgs.getSourceFormatterProperties();
    }

    @Input
    public boolean isAutoFix() {
        return this._sourceFormatterArgs.isAutoFix();
    }

    @Input
    public boolean isFailOnAutoFix() {
        return this._sourceFormatterArgs.isFailOnAutoFix();
    }

    @Input
    public boolean isFailOnHasWarning() {
        return this._sourceFormatterArgs.isFailOnHasWarning();
    }

    @Input
    public boolean isFormatCurrentBranch() {
        return this._sourceFormatterArgs.isFormatCurrentBranch();
    }

    @Input
    public boolean isFormatLatestAuthor() {
        return this._sourceFormatterArgs.isFormatLatestAuthor();
    }

    @Input
    public boolean isFormatLocalChanges() {
        return this._sourceFormatterArgs.isFormatLocalChanges();
    }

    @Input
    public boolean isIncludeSubrepositories() {
        return this._sourceFormatterArgs.isIncludeSubrepositories();
    }

    @Input
    public boolean isJavaParserEnabled() {
        return this._sourceFormatterArgs.isJavaParserEnabled();
    }

    @Input
    public boolean isPrintErrors() {
        return this._sourceFormatterArgs.isPrintErrors();
    }

    @Input
    public boolean isShowDebugInformation() {
        return this._sourceFormatterArgs.isShowDebugInformation();
    }

    @Input
    public boolean isValidateCommitMessages() {
        return this._sourceFormatterArgs.isValidateCommitMessages();
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDirName(String baseDirName) {
        this._sourceFormatterArgs.setBaseDirName(baseDirName);
    }

    public void setCheckCategoryNames(Iterable<String> checkCategoryNames) {
        this._sourceFormatterArgs.setCheckCategoryNames(CollectionUtils.toList(checkCategoryNames));
    }

    public void setCheckCategoryNames(String ... checkCategoryNames) {
        this._sourceFormatterArgs.setCheckCategoryNames(CollectionUtils.toList((Object[])checkCategoryNames));
    }

    public void setCheckNames(Iterable<String> checkNames) {
        this._sourceFormatterArgs.setCheckNames(CollectionUtils.toList(checkNames));
    }

    public void setCheckNames(String ... checkNames) {
        this._sourceFormatterArgs.setCheckNames(CollectionUtils.toList((Object[])checkNames));
    }

    public void setFailOnAutoFix(boolean failOnAutoFix) {
        this._sourceFormatterArgs.setFailOnAutoFix(failOnAutoFix);
    }

    public void setFailOnHasWarning(boolean failOnHasWarning) {
        this._sourceFormatterArgs.setFailOnHasWarning(failOnHasWarning);
    }

    public void setFileExtensions(Iterable<String> fileExtensions) {
        this._sourceFormatterArgs.setFileExtensions(CollectionUtils.toList(fileExtensions));
    }

    public void setFileExtensions(String ... fileExtensions) {
        this._sourceFormatterArgs.setFileExtensions(CollectionUtils.toList((Object[])fileExtensions));
    }

    public void setFileNames(Iterable<String> fileNames) {
        this._sourceFormatterArgs.setFileNames(CollectionUtils.toStringList(fileNames));
    }

    public void setFileNames(String ... fileNames) {
        this.setFileNames(Arrays.asList(fileNames));
    }

    public void setFormatCurrentBranch(boolean formatCurrentBranch) {
        this._sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setGitWorkingBranchName(String gitWorkingBranchName) {
        this._sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
    }

    public void setIncludeSubrepositories(boolean includeSubrepositories) {
        this._sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
    }

    public void setJavaParserEnabled(boolean javaParserEnabled) {
        this._sourceFormatterArgs.setJavaParserEnabled(javaParserEnabled);
    }

    public void setMaxLineLength(int maxLineLength) {
        this._sourceFormatterArgs.setMaxLineLength(maxLineLength);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setProcessorThreadCount(int processorThreadCount) {
        this._sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
    }

    public void setShowDebugInformation(boolean showDebugInformation) {
        this._sourceFormatterArgs.setShowDebugInformation(showDebugInformation);
    }

    public void setValidateCommitMessages(boolean validateCommitMessages) {
        this._sourceFormatterArgs.setValidateCommitMessages(validateCommitMessages);
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("format.current.branch=" + this.isFormatCurrentBranch());
        args.add("format.latest.author=" + this.isFormatLatestAuthor());
        args.add("format.local.changes=" + this.isFormatLocalChanges());
        args.add("git.working.branch.name=" + this.getGitWorkingBranchName());
        args.add("include.subrepositories=" + this.isIncludeSubrepositories());
        args.add("java.parser.enabled=" + this.isJavaParserEnabled());
        args.add("max.line.length=" + this.getMaxLineLength());
        args.add("processor.thread.count=" + this.getProcessorThreadCount());
        args.add("show.debug.information=" + this.isShowDebugInformation());
        args.add("source.auto.fix=" + this.isAutoFix());
        args.add("source.check.category.names=" + CollectionUtils.join((String)",", this.getCheckCategoryNames()));
        args.add("source.check.names=" + CollectionUtils.join((String)",", this.getCheckNames()));
        args.add("source.fail.on.auto.fix=" + this.isFailOnAutoFix());
        args.add("source.fail.on.has.warning=" + this.isFailOnHasWarning());
        args.add("source.file.extensions=" + CollectionUtils.join((String)",", this.getFileExtensions()));
        args.add("source.formatter.properties=" + CollectionUtils.join((String)",", this.getSourceFormatterProperties()));
        args.add("source.print.errors=" + this.isPrintErrors());
        args.add("validate.commit.messages=" + this.isValidateCommitMessages());
        FileCollection fileCollection = this.getFiles();
        if (fileCollection.isEmpty()) {
            args.add("source.base.dir=" + this._normalize(this.getBaseDir()));
        } else {
            args.add("source.files=" + this._merge((Iterable<File>)fileCollection));
        }
        return args;
    }

    private String _merge(Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (File file : files) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this._normalize(file));
            ++i;
        }
        return sb.toString();
    }

    private String _normalize(File file) {
        String pathString = String.valueOf(file.toPath());
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        if (pathString.charAt(pathString.length() - 1) != '/') {
            pathString = pathString + '/';
        }
        return pathString;
    }
}

