/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.LiferayRelengUtil;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class MavenPublishDefaultsPlugin
extends BaseDefaultsPlugin<MavenPublishPlugin> {
    public static final Plugin<Project> INSTANCE = new MavenPublishDefaultsPlugin();
    protected static final Action<Task> failReleaseOnWrongBranchAction = new Action<Task>(){

        public void execute(Task task) {
            Project project = task.getProject();
            File relengIgnoreDir = GradleUtil.getRootDir((Project)project, (String)".lfrbuild-releng-ignore");
            if (relengIgnoreDir != null) {
                return;
            }
            File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
            if (portalRootDir == null) {
                return;
            }
            if (GradlePluginsDefaultsUtil.isSnapshot(project)) {
                File relengDir = new File(portalRootDir, "modules/.releng");
                if (relengDir.exists()) {
                    throw new GradleException("Please run this task from a master branch instead");
                }
                return;
            }
            File releasePortalRootDir = GradleUtil.getProperty((Project)project, (String)"release.versions.test.other.dir", (File)null);
            if (releasePortalRootDir == null) {
                throw new GradleException("Please set the property \"release.versions.test.other.dir\".");
            }
            String relativePath = FileUtil.relativize((File)project.getProjectDir(), (File)portalRootDir);
            File releaseProjectDir = new File(releasePortalRootDir, relativePath);
            if (!releaseProjectDir.exists()) {
                return;
            }
            File relengDir = LiferayRelengUtil.getRelengDir(project);
            File releaseRelengDir = LiferayRelengUtil.getRelengDir(releaseProjectDir);
            if (relengDir == null && releaseRelengDir != null && releaseRelengDir.isDirectory()) {
                throw new GradleException("Please run this task from " + releaseProjectDir + " instead");
            }
        }
    };

    protected void applyPluginDefaults(Project project, MavenPublishPlugin mavenPublishPlugin) {
        this._configureTaskPublish(project);
    }

    protected Class<MavenPublishPlugin> getPluginClass() {
        return MavenPublishPlugin.class;
    }

    private MavenPublishDefaultsPlugin() {
    }

    private void _configureTaskPublish(Project project) {
        Task publishTask = GradleUtil.getTask((Project)project, (String)"publish");
        publishTask.doFirst(failReleaseOnWrongBranchAction);
    }
}

