/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.util.Validator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.util.GUtil;

public class CIUtil {
    public static boolean isExcludedDependencyProject(Project project, Project dependencyProject) {
        File bndFile = project.file((Object)"bnd.bnd");
        if (!Files.exists(bndFile.toPath(), new LinkOption[0])) {
            return false;
        }
        File dependencyBndFile = dependencyProject.file((Object)"bnd.bnd");
        if (!Files.exists(dependencyBndFile.toPath(), new LinkOption[0])) {
            return false;
        }
        Properties dependencyProperties = GUtil.loadProperties((File)dependencyBndFile);
        String dependencyExportPackage = dependencyProperties.getProperty("Export-Package");
        if (Validator.isNotNull((String)dependencyExportPackage)) {
            Properties properties = GUtil.loadProperties((File)bndFile);
            String importPackage = properties.getProperty("Import-Package");
            if (Validator.isNull((String)importPackage)) {
                return false;
            }
            List<String> importPackages = Arrays.asList(importPackage.split(","));
            for (String exportPackage : dependencyExportPackage.split(",")) {
                if (importPackages.contains("!" + exportPackage)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRunningInCIEnvironment() {
        return Validator.isNotNull((String)System.getenv("JENKINS_HOME"));
    }

    public static boolean isRunningInCIPatcherEnvironment() {
        return Validator.isNotNull((String)System.getenv("FIX_PACKS_RELEASE_ENVIRONMENT"));
    }
}

