/*
 * Decompiled with CFR 0.152.
 */
package com.frontend.js.minifier;

import com.frontend.js.minifier.configuration.YahooJavaScriptMinifierConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.frontend.js.minifier.configuration.YahooJavaScriptMinifierConfiguration"}, immediate=true, service={JavaScriptMinifier.class})
public class YahooJavaScriptMinifier
implements JavaScriptMinifier {
    private static final Log _log = LogFactoryUtil.getLog(YahooJavaScriptMinifier.class);
    private YahooJavaScriptMinifierConfiguration _yahooJavaScriptMinifierConfiguration;

    public String compress(String resourceName, String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor((Reader)new UnsyncStringReader(content), (ErrorReporter)new JavaScriptErrorReporter());
            javaScriptCompressor.compress((Writer)unsyncStringWriter, this._yahooJavaScriptMinifierConfiguration.jsLineBreak(), this._yahooJavaScriptMinifierConfiguration.jsMunge(), this._yahooJavaScriptMinifierConfiguration.jsVerbose(), this._yahooJavaScriptMinifierConfiguration.jsPreserveAllSemicolons(), this._yahooJavaScriptMinifierConfiguration.jsDisableOptimizations());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to minify JavaScript:\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._yahooJavaScriptMinifierConfiguration = (YahooJavaScriptMinifierConfiguration)ConfigurableUtil.createConfigurable(YahooJavaScriptMinifierConfiguration.class, properties);
    }

    private static class JavaScriptErrorReporter
    implements ErrorReporter {
        private JavaScriptErrorReporter() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                _log.error((Object)message);
            } else {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{line, ": ", lineOffset, ": ", message}));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!_log.isWarnEnabled()) {
                return;
            }
            if (line < 0) {
                _log.warn((Object)message);
            } else {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{line, ": ", lineOffset, ": ", message}));
            }
        }
    }
}

