/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin.ResourceDescriptor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class BaseBuiltInJSModuleServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(BaseBuiltInJSModuleServlet.class);
    private ServiceTrackerMap<String, ResourceBundleLoader> _serviceTrackerMap;
    private final String _workDirName = StringBundler.concat((String[])new String[]{PropsValues.LIFERAY_HOME, File.separator, "work"});

    public void destroy() {
        this._serviceTrackerMap.close();
    }

    public void init() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundle.getBundleContext(), ResourceBundleLoader.class, (String)"bundle.symbolic.name");
    }

    protected abstract MimeTypes getMimeTypes();

    protected abstract ResourceDescriptor getResourceDescriptor(String var1);

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String pathInfo = httpServletRequest.getPathInfo();
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor(pathInfo);
        if (resourceDescriptor == null) {
            httpServletResponse.sendError(404);
            return;
        }
        this._setContentType(httpServletResponse, pathInfo);
        String languageId = httpServletRequest.getParameter("languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        this._sendResource(httpServletResponse, resourceDescriptor, locale, pathInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendResource(HttpServletResponse httpServletResponse, ResourceDescriptor resourceDescriptor, Locale locale, String pathInfo) throws IOException {
        InputStream inputStream = null;
        String extension = FileUtil.getExtension((String)pathInfo);
        JSPackage jsPackage = resourceDescriptor.getJsPackage();
        String moduleName = resourceDescriptor.getPackagePath();
        if (moduleName != null) {
            if (extension.equals("map")) {
                jsModule = jsPackage.getJSModule(moduleName.substring(0, moduleName.length() - 7));
                if (jsModule != null) {
                    inputStream = jsModule.getSourceMapInputStream();
                }
            } else {
                if (extension.equals("js")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 3);
                }
                if ((jsModule = jsPackage.getJSModule(moduleName)) != null) {
                    inputStream = jsModule.getInputStream();
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"Module name is null");
        }
        if (inputStream == null) {
            httpServletResponse.sendError(404);
            return;
        }
        try {
            JSBundle jsBundle;
            ResourceBundleLoader resourceBundleLoader;
            String content = StringUtil.read(inputStream);
            httpServletResponse.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            if (extension.equals("js") && (resourceBundleLoader = (ResourceBundleLoader)this._serviceTrackerMap.getService((Object)(jsBundle = jsPackage.getJSBundle()).getName())) != null) {
                content = LanguageUtil.process(() -> resourceBundleLoader.loadResourceBundle(locale), (Locale)locale, (String)content);
            }
            printWriter.print(content);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read " + resourceDescriptor.toString()), (Throwable)ioException);
            httpServletResponse.sendError(500, "Unable to read file");
        }
        finally {
            inputStream.close();
        }
    }

    private void _setContentType(HttpServletResponse httpServletResponse, String pathInfo) {
        String extension = FileUtil.getExtension((String)pathInfo);
        if (extension.equals("js")) {
            httpServletResponse.setContentType("text/javascript; charset=UTF-8");
        } else if (extension.equals("map")) {
            httpServletResponse.setContentType("application/json");
        } else {
            MimeTypes mimeTypes = this.getMimeTypes();
            httpServletResponse.setContentType(mimeTypes.getContentType(pathInfo));
        }
    }
}

