/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.servlet;

import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolution;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolver;
import com.liferay.frontend.js.loader.modules.extender.internal.servlet.util.JSLoaderModulesUtil;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.loader.modules.extender.internal.servlet.JSResolveModulesServlet", "osgi.http.whiteboard.servlet.pattern=/js_resolve_modules", "service.ranking:Integer=2147482647"}, service={Servlet.class})
public class JSResolveModulesServlet
extends HttpServlet {
    @Reference
    private BrowserModulesResolver _browserModulesResolver;

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-48372")) {
            return;
        }
        if (JSLoaderModulesUtil.eTagEquals(httpServletRequest.getHeader("If-None-Match"))) {
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.addHeader("Cache-Control", "no-cache");
        httpServletResponse.addHeader("ETag", JSLoaderModulesUtil.getETag());
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream(), true);
        BrowserModulesResolution browserModulesResolution = this._browserModulesResolver.resolve(this._getModuleNames(httpServletRequest), httpServletRequest);
        printWriter.write(browserModulesResolution.toJSON());
        printWriter.close();
    }

    private List<String> _getModuleNames(HttpServletRequest httpServletRequest) throws IOException {
        String[] moduleNames = null;
        String method = httpServletRequest.getMethod();
        if (method.equals("GET")) {
            moduleNames = ParamUtil.getStringValues((HttpServletRequest)httpServletRequest, (String)"modules");
        } else {
            String body = StringUtil.read((InputStream)httpServletRequest.getInputStream());
            if (!(body = URLDecoder.decode(body, httpServletRequest.getCharacterEncoding())).isEmpty()) {
                body = body.substring(8);
                moduleNames = body.split(",");
            }
        }
        if (moduleNames != null) {
            return Arrays.asList(moduleNames);
        }
        return Collections.emptyList();
    }
}

