/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModifiableJSPackage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FlatJSPackage
implements ModifiableJSPackage {
    private final FlatJSBundle _flatJSBundle;
    private final List<JSModuleAlias> _jsModuleAliases = new ArrayList<JSModuleAlias>();
    private final ConcurrentMap<String, JSModule> _jsModules = new ConcurrentHashMap<String, JSModule>();
    private final Map<String, JSPackageDependency> _jsPackageDependencies = new HashMap<String, JSPackageDependency>();
    private final String _mainModuleName;
    private final String _name;
    private final boolean _root;
    private final String _version;

    public FlatJSPackage(FlatJSBundle flatJSBundle, String name, String version, String mainModuleName, boolean root) {
        this._flatJSBundle = flatJSBundle;
        this._name = name;
        this._version = version;
        this._mainModuleName = mainModuleName;
        this._root = root;
    }

    public void addJSModule(JSModule jsModule) {
        if (jsModule.getJSPackage() != this) {
            throw new IllegalArgumentException("The given JS module does not belong to this JS package");
        }
        if (this._jsModules.putIfAbsent(jsModule.getName(), jsModule) != null) {
            throw new IllegalStateException("A JS module with the same name already exists");
        }
    }

    public void addJSModuleAlias(JSModuleAlias jsModuleAlias) {
        this._jsModuleAliases.add(jsModuleAlias);
    }

    public void addJSPackageDependency(JSPackageDependency jsPackageDependency) {
        this._jsPackageDependencies.put(jsPackageDependency.getPackageName(), jsPackageDependency);
    }

    public String getId() {
        return StringBundler.concat((String[])new String[]{this._flatJSBundle.getId(), "/", this._name, "@", this._version});
    }

    public FlatJSBundle getJSBundle() {
        return this._flatJSBundle;
    }

    public JSModule getJSModule(String packagePath) {
        return (JSModule)this._jsModules.get(packagePath);
    }

    public Collection<JSModuleAlias> getJSModuleAliases() {
        return this._jsModuleAliases;
    }

    public Collection<JSModule> getJSModules() {
        return this._jsModules.values();
    }

    public Collection<JSPackageDependency> getJSPackageDependencies() {
        return this._jsPackageDependencies.values();
    }

    public JSPackageDependency getJSPackageDependency(String packageName) {
        return this._jsPackageDependencies.get(packageName);
    }

    public String getMainModuleName() {
        return this._mainModuleName;
    }

    public String getName() {
        return this._name;
    }

    public String getResolvedId() {
        return StringBundler.concat((String[])new String[]{this._name, "@", this._version});
    }

    public URL getResourceURL(String location) {
        String path = "META-INF/resources/";
        if (this._root) {
            path = path.concat(location);
        } else {
            StringBundler sb = new StringBundler(6);
            sb.append("META-INF/resources/node_modules/");
            if (this._name.startsWith("@")) {
                sb.append(StringUtil.replace((String)this._name, (char)'/', (String)"%2F"));
            } else {
                sb.append(this._name);
            }
            sb.append("@");
            sb.append(this._version);
            sb.append("/");
            sb.append(location);
            path = sb.toString();
        }
        return this._flatJSBundle.getResourceURL(path);
    }

    public String getVersion() {
        return this._version;
    }

    public void removeJSModule(JSModule jsModule) {
        if (jsModule.getJSPackage() != this) {
            throw new IllegalArgumentException("The given JS module does not belong to this JS package");
        }
        this._jsModules.remove(jsModule.getName());
    }

    public void replaceJSModule(JSModule jsModule) {
        if (jsModule.getJSPackage() != this) {
            throw new IllegalArgumentException("The given JS module does not belong to this JS package");
        }
        if (this._jsModules.replace(jsModule.getName(), jsModule) == null) {
            throw new IllegalArgumentException("No JS module with the same name exists");
        }
    }

    public String toString() {
        return this.getId();
    }
}

