/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.petra.string.StringBundler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BrowserModuleNameMapperCache {
    private final Map<String, String> _cache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _exactMatchMap;
    private final long _lastModified;
    private final Map<String, String> _partialMatchMap;

    public BrowserModuleNameMapperCache(Map<String, String> exactMatchMap, Map<String, String> partialMatchMap) {
        this._exactMatchMap = exactMatchMap;
        this._partialMatchMap = partialMatchMap;
        this._lastModified = System.currentTimeMillis();
    }

    public String get(String moduleName, Map<String, String> dependenciesMap) {
        return this._cache.get(this._buildKey(moduleName, dependenciesMap));
    }

    public Map<String, String> getExactMatchMap() {
        return this._exactMatchMap;
    }

    public Map<String, String> getPartialMatchMap() {
        return this._partialMatchMap;
    }

    public boolean isOlderThan(long lastModified) {
        return this._lastModified < lastModified;
    }

    public void put(String moduleName, Map<String, String> dependenciesMap, String mappedModuleName) {
        this._cache.put(this._buildKey(moduleName, dependenciesMap), mappedModuleName);
    }

    private String _buildKey(String moduleName, Map<String, String> dependenciesMap) {
        if (dependenciesMap == null) {
            return moduleName;
        }
        StringBundler sb = new StringBundler();
        sb.append(moduleName);
        for (Map.Entry<String, String> entry : dependenciesMap.entrySet()) {
            sb.append("|");
            sb.append(entry.getKey());
            sb.append("|");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }
}

